# NNN40 WI-FI SDK version 20150524, release at 2015/5/24
This is the export repo for the WIFI_API provided by Delta Electronics, Inc.

# Fixed bug in previous version
* Fix wifi inti fail (timing issue) issue
* Change type of ap_ssid and ap_pw to char*
* Command getNetworkMask() and getGateway()  
* Bug fix: is_connect() return 0 when close() function is called
* Bug fix: listen() return 0
* Change TCP ERROR retry to 3 times
* WIFI SPI interface change to SPI0
* WIFI MAC Address readout from Flash
* UART conflict bug fix 
* Fix is_connect return error when ethernet is disconnected
* Set TCP maximum payload to 512 bytes
* Set UDP maximum payload to 256 bytes
* Fix UDP send_to length issue
* Fix send_to return error when client socket is colsed
* Set IP 255.255.255.255 as reserved
* Fix Switch return error when ethernet is init
* Fix bug in spi_flash.c for data access
* Fix bind return error 

# Fixed bug in this version
* Support DNS client for TCP/UDP
* Fast AP re-connection is performed automatically, user can call EthernetInterface.disconnect() to have lowest power consumption of 4uA, then call init and connected to previous AP for less than 4 sec

# Supported functionalities 
Currently supported  functionalities include:
* IEEE 802.11 b/g/n connectivity
* Station (STA) infrastructure mode
* WEP/WPA/WPA2 security
* DHCP Client and Static IPv4 addressing
* TCP Server/Client
* UDP Server/Client

# Getting Started 
This WIFI API is meant to be used on Delta NNN40 EVB. 
A good starting point are these pages:
* [WI-FI SDK User Guide](document come with WI-FI SDK deliver) for system overview, APIs summary and sample code
* [EthernetInterface - Handbook](http://developer.mbed.org/handbook/Ethernet-Interface) a simple API that you will need to connect to the internet.
* [Socket - Handbook](http://developer.mbed.org/handbook/Socket) a simple and consistent way to communicate using bsd-like TCP and UDP sockets over WI-FI 