#ifndef KALMAN_H
#define KALMAN_H

#include "mbed.h"
#include <stdlib.h>
#include <math.h>
static double dt;

/*PITCH*/
/* Kalman filter variables*/
static double Q_angle_pitch;    // Process noise variance for the accelerometer
static double Q_bias_pitch;     // Process noise variance for the gyro bias
static double R_measure_pitch;  // Measurement noise variance - this is actually the variance of the measurement noise

static double angle_pitch;      // The angle calculated by the Kalman filter - part of the 2x1 state matrix
static double bias_pitch;       // The gyro bias calculated by the Kalman filter - part of the 2x1 state matrix
static double rate_pitch;       // Unbiased rate calculated from the rate and the calculated bias - you have to call getAngle to update the rate
static double newAngle_pitch;
static double newRate_pitch;

static double P_pitch[2][2]; // Error covariance matrix - This is a 2x2 matrix
static double K_pitch[2]; // Kalman gain - This is a 2x1 matrix
static double y_pitch; // Angle difference - 1x1 matrix
static double S_pitch; // Estimate error - 1x1 matrix

/*ROLL*/
/* Kalman filter variables*/
static double Q_angle_roll;    // Process noise variance for the accelerometer
static double Q_bias_roll;     // Process noise variance for the gyro bias
static double R_measure_roll;  // Measurement noise variance - this is actually the variance of the measurement noise

static double angle_roll;      // The angle calculated by the Kalman filter - part of the 2x1 state matrix
static double bias_roll;       // The gyro bias calculated by the Kalman filter - part of the 2x1 state matrix
static double rate_roll;       // Unbiased rate calculated from the rate and the calculated bias - you have to call getAngle to update the rate
static double newAngle_roll;
static double newRate_roll;

static double P_roll[2][2]; // Error covariance matrix - This is a 2x2 matrix
static double K_roll[2]; // Kalman gain - This is a 2x1 matrix
static double y_roll; // Angle difference - 1x1 matrix
static double S_roll; // Estimate error - 1x1 matrix

/*Yaw*/
/* Kalman filter variables*/
static double Q_angle_yaw;    // Process noise variance for the accelerometer
static double Q_bias_yaw;     // Process noise variance for the gyro bias
static double R_measure_yaw;  // Measurement noise variance - this is actually the variance of the measurement noise

static double angle_yaw;      // The angle calculated by the Kalman filter - part of the 2x1 state matrix
static double bias_yaw;       // The gyro bias calculated by the Kalman filter - part of the 2x1 state matrix
static double rate_yaw;       // Unbiased rate calculated from the rate and the calculated bias - you have to call getAngle to update the rate
static double newAngle_yaw;
static double newRate_yaw;

static double P_yaw[2][2]; // Error covariance matrix - This is a 2x2 matrix
static double K_yaw[2]; // Kalman gain - This is a 2x1 matrix
static double y_yaw; // Angle difference - 1x1 matrix
static double S_yaw; // Estimate error - 1x1 matrix





double getRate(double *rate);

void Kalman_yaw(void); 
void Kalman_pitch(void); 
void Kalman_roll(void); 

 
double getPitch(double *newAngle_pitch, double *newRate_pitch, double *dt);
double getRoll(double *newAngle_roll, double *newRate_roll, double *dt);
double getYaw(double *newAngle_yaw, double *newRate_yaw, double *dt);




void setAngle(double *newAngle, double *angle); 



void setQangle(double *newQ_angle, double *Q_angle); 
void setQbias(double *newQ_bias, double *Q_bias); 
void setRmeasure(double newR_measure);





#endif