#include "Kalman.h"
#include "mbed.h"

/*PITCH*/
/*PITCH*/
/*PITCH*/

void Kalman_pitch(void) 
{
    /* We will set the varibles like so, these can also be tuned by the user */
    Q_angle_pitch = 0.1;
    Q_bias_pitch = 0.003;
    R_measure_pitch = 0.1;
    
    angle_pitch = 1.2;
    bias_pitch = -0.4; // Reset bias
    // Since we assume tha the bias is 0 and we know the starting angle (use setAngle), 
    // the error covariance matrix is set like so - see: http://en.wikipedia.org/wiki/Kalman_filter#Example_application.2C_technical
    P_pitch[0][0] = 0;
    P_pitch[0][1] = 0;
    P_pitch[1][0] = 0;
    P_pitch[1][1] = 0;
}
// The angle should be in degrees and the rate should be in degrees per second and the delta time in seconds
double getPitch(double *newAngle_pitch, double *newRate_pitch, double *dt) 
{
    // Discrete Kalman filter time update equations - Time Update ("Predict")
    // Update xhat - Project the state ahead
    /* Step 1 */
    rate_pitch = (*newRate_pitch) - bias_pitch;
    angle_pitch += (*dt) * rate_pitch;
    
    // Update estimation error covariance - Project the error covariance ahead
    /* Step 2 */
    P_pitch[0][0] += (*dt) * ((*dt) * P_pitch[1][1] - P_pitch[0][1] - P_pitch[1][0] + Q_angle_pitch);
    P_pitch[0][1] -= (*dt) * P_pitch[1][1];
    P_pitch[1][0] -= (*dt) * P_pitch[1][1];
    P_pitch[1][1] += Q_bias_pitch * (*dt);
    
    // Discrete Kalman filter measurement update equations - Measurement Update ("Correct")
    // Calculate Kalman gain - Compute the Kalman gain
    /* Step 4 */
    S_pitch = P_pitch[0][0] + R_measure_pitch;
    /* Step 5 */
    K_pitch[0] = P_pitch[0][0] / S_pitch;
    K_pitch[1] = P_pitch[1][0] / S_pitch;
    
    // Calculate angle and bias - Update estimate with measurement zk (newAngle)
    /* Step 3 */
    y_pitch = (*newAngle_pitch) - angle_pitch;
    /* Step 6 */
    angle_pitch += K_pitch[0] * y_pitch;
    bias_pitch += K_pitch[1] * y_pitch;
    
    // Calculate estimation error covariance - Update the error covariance
    /* Step 7 */
    P_pitch[0][0] -= K_pitch[0] * P_pitch[0][0];
    P_pitch[0][1] -= K_pitch[0] * P_pitch[0][1];
    P_pitch[1][0] -= K_pitch[1] * P_pitch[0][0];
    P_pitch[1][1] -= K_pitch[1] * P_pitch[0][1];
    
    return angle_pitch;
}

/*YAW*/
/*YAW*/
/*YAW*/

void Kalman_yaw(void) 
{
    /* We will set the varibles like so, these can also be tuned by the user */
    Q_angle_yaw = 0.001;
    Q_bias_yaw = 0.003;
    R_measure_yaw = 0.03;
    
    bias_yaw = 0; // Reset bias
    // Since we assume tha the bias is 0 and we know the starting angle (use setAngle), 
    // the error covariance matrix is set like so - see: http://en.wikipedia.org/wiki/Kalman_filter#Example_application.2C_technical
    P_yaw[0][0] = 0;
    P_yaw[0][1] = 0;
    P_yaw[1][0] = 0;
    P_yaw[1][1] = 0;
}
// The angle should be in degrees and the rate should be in degrees per second and the delta time in seconds
double getYaw(double *newAngle_yaw, double *newRate_yaw, double *dt) 
{
    // Discrete Kalman filter time update equations - Time Update ("Predict")
    // Update xhat - Project the state ahead
    /* Step 1 */
    rate_yaw = (*newRate_yaw) - bias_yaw;
    angle_yaw += (*dt) * rate_yaw;
    
    (*newAngle_yaw) = angle_yaw;
    
    // Update estimation error covariance - Project the error covariance ahead
    /* Step 2 */
    P_yaw[0][0] += (*dt) * ((*dt) * P_yaw[1][1] - P_yaw[0][1] - P_yaw[1][0] + Q_angle_yaw);
    P_yaw[0][1] -= (*dt) * P_yaw[1][1];
    P_yaw[1][0] -= (*dt) * P_yaw[1][1];
    P_yaw[1][1] += Q_bias_yaw * (*dt);
    
    // Discrete Kalman filter measurement update equations - Measurement Update ("Correct")
    // Calculate Kalman gain - Compute the Kalman gain
    /* Step 4 */
    S_yaw = P_yaw[0][0] + R_measure_yaw;
    /* Step 5 */
    K_yaw[0] = P_yaw[0][0] / S_yaw;
    K_yaw[1] = P_yaw[1][0] / S_yaw;
    
    // Calculate angle and bias - Update estimate with measurement zk (newAngle)
    /* Step 3 */
    y_yaw = (*newAngle_yaw) - angle_yaw;
    /* Step 6 */
    angle_yaw += K_yaw[0] * y_yaw;
    bias_yaw += K_yaw[1] * y_yaw;
    
    // Calculate estimation error covariance - Update the error covariance
    /* Step 7 */
    P_yaw[0][0] -= K_yaw[0] * P_yaw[0][0];
    P_yaw[0][1] -= K_yaw[0] * P_yaw[0][1];
    P_yaw[1][0] -= K_yaw[1] * P_yaw[0][0];
    P_yaw[1][1] -= K_yaw[1] * P_yaw[0][1];
    
    return angle_yaw;
}


void Kalman_roll(void) 
{
    /* We will set the varibles like so, these can also be tuned by the user */
    Q_angle_roll = 0.001;
    Q_bias_roll = 0.1;
    R_measure_roll = 0.1;
    
    angle_roll = 1.2;
    bias_roll = 1.2; // Reset bias
    // Since we assume tha the bias is 0 and we know the starting angle (use setAngle), 
    // the error covariance matrix is set like so - see: http://en.wikipedia.org/wiki/Kalman_filter#Example_application.2C_technical
    P_roll[0][0] = 0;
    P_roll[0][1] = 0;
    P_roll[1][0] = 0;
    P_roll[1][1] = 0;
}

/*ROLL*/
/*ROLL*/
/*ROLL*/

// The angle should be in degrees and the rate should be in degrees per second and the delta time in seconds
double getRoll(double *newAngle_roll, double *newRate_roll, double *dt) 
{
    // Discrete Kalman filter time update equations - Time Update ("Predict")
    // Update xhat - Project the state ahead
    /* Step 1 */
    rate_roll = (*newRate_roll) - bias_roll;
    angle_roll += (*dt) * rate_roll;
    
    // Update estimation error covariance - Project the error covariance ahead
    /* Step 2 */
    P_roll[0][0] += (*dt) * ((*dt) * P_roll[1][1] - P_roll[0][1] - P_roll[1][0] + Q_angle_roll);
    P_roll[0][1] -= (*dt) * P_roll[1][1];
    P_roll[1][0] -= (*dt) * P_roll[1][1];
    P_roll[1][1] += Q_bias_roll * (*dt);
    
    // Discrete Kalman filter measurement update equations - Measurement Update ("Correct")
    // Calculate Kalman gain - Compute the Kalman gain
    /* Step 4 */
    S_roll = P_roll[0][0] + R_measure_roll;
    /* Step 5 */
    K_roll[0] = P_roll[0][0] / S_roll;
    K_roll[1] = P_roll[1][0] / S_roll;
    
    // Calculate angle and bias - Update estimate with measurement zk (newAngle)
    /* Step 3 */
    y_roll = (*newAngle_roll) - angle_roll;
    /* Step 6 */
    angle_roll += K_roll[0] * y_roll;
    bias_roll += K_roll[1] * y_roll;
    
    // Calculate estimation error covariance - Update the error covariance
    /* Step 7 */
    P_roll[0][0] -= K_roll[0] * P_roll[0][0];
    P_roll[0][1] -= K_roll[0] * P_roll[0][1];
    P_roll[1][0] -= K_roll[1] * P_roll[0][0];
    P_roll[1][1] -= K_roll[1] * P_roll[0][1];
    
    return angle_roll;
}








// Used to set angle, this should be set as the starting angle
void setAngle(double *newAngle, double *angle) 
{ 
    (*angle) = (*newAngle); 
}
// Return the unbiased rate
double getRate(double *rate) 
{ 
    return (*rate); 
}

/* These are used to tune the Kalman filter */
void setQangle(double *newQ_angle, double *Q_angle) 
{ 
    (*Q_angle) = (*newQ_angle); 
}
void setQbias(double *newQ_bias, double *Q_bias) 
{ 
    (*Q_bias) = (*newQ_bias); 
}
void setRmeasure(double *newR_measure, double *R_measure) 
{
    (*R_measure) = (*newR_measure); 
}


