/************************************************************************************
Copyright (c) 2014 Marcus Parker  Sapphire Research and Electronics ltd
    
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. 

This program uses the following libraries:  
mbed by mbed_official                       
TextLCD by Simon_Ford                       
TMP36GZ by Tyler_Weaver                     
RepeatButton by Jeroen_Hilgers              
                                           
Wiring instructions:                        
Two external buttons -> PB_4 and PB_3 
TMP36GZ pwr->3.3v, Vout->PA_0               
LCD connections as below                    
*****************************************************************************************/

#include "mbed.h"
#include "TextLCD.h"
#include "TMP36GZ.h"
#include "RepeatButton.h"

using namespace std;
#define REPEAT_DELAY 500
#define REPEAT_PERIOD 100
#define KEY_UP 2
#define KEY_DOWN 4

Ticker tick;
TextLCD lcd(PC_10, PC_12, PA_13, PA_14, PA_15, PB_7); // rs, e, d4-d7
TMP36GZ temp(PA_0); 
DigitalOut led(LED1);

KeyBuffer TheKeyBuffer(32);
RepeatButton butUp(PB_4, REPEAT_DELAY, REPEAT_PERIOD, &TheKeyBuffer, KEY_UP);
RepeatButton butDown(PB_3, REPEAT_DELAY, REPEAT_PERIOD, &TheKeyBuffer, KEY_DOWN);

float d, level;

void disp() 
{
    lcd.locate(0, 0); 
    lcd.printf("%3.1f %cC", d, 223);
    lcd.locate(0, 1);
    lcd.printf("Trip %3.1f", level);  
}

int main() 
{
    level = 25.0;  //Initial trip level value
    float leveloff;
    int value;
    
    tick.attach(&disp, 0.5); //Calls display every 0.5 seconds
    
    while(1) 
    { 
    d = temp.sample();  //Define d as temp celsius reading
    leveloff = (level - 2);
    
    for(value = TheKeyBuffer.Read(); value != -1; value = TheKeyBuffer.Read()) //Button 1 and Button 3 increase and decrease trip level
    {
        switch(value)
        {
            case KEY_UP:
            level += 0.1;
            break;
                
            case KEY_DOWN:
            level -= 0.1;
            break;
        }
    } 

    if(d >= level) //Led will light up if temperature is above trip level
    {
    led = 1;
    }
    else if(d <= leveloff)
    {
    led = 0;
    }   
    } 
}
