#include "mbed.h"
#include "TextLCD.h"
#include "cc3000.h"
#include "main.h"


using namespace mbed_cc3000;

#if (MY_BOARD == WIFI_SHEILD_ADAFRUIT)
cc3000 wifi(PB_3, PB_4, PB_6, SPI(PA_7, PA_6, PA_5), "SSID", "PASSWORD", WPA, false); //irq, en, cs, spi, irq-port
Serial pc(USBTX, USBRX); // tx, rx
#endif

TextLCD lcd(PC_8, PC_6, PC_5, PB_15, PB_14, PB_12); // rs, e, d4-d7
DigitalOut led(PC_10);

int main() 
{
    lcd.cls();
    lcd.printf("CC3000 Ping");
    
    led = 0;
    wifi.init();
    
    if (wifi.connect(5000) == false) 
    {
        lcd.locate(0, 0);
        lcd.printf("Return 1");
    } 
    else 
    {
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("IP address:");
        lcd.locate(0, 1);
        lcd.printf("%s",wifi.getIPAddress());
    }
    
     wait(5);
    
    uint32_t ip;
    uint8_t *site = (uint8_t *)"google.com";
    
    printf("IP of %s ",site);
    if (wifi._socket.gethostbyname(site,strlen((const char *)site), &ip)) 
    {
        uint8_t add0 = (ip >> 24);
        uint8_t add1 = (ip >> 16);
        uint8_t add2 = (ip >> 8);
        uint8_t add3 = (ip >> 0);
        printf("IP address of %s: %d:%d:%d:%d \r\n", site, add0, add1, add2, add3);
        led = 1;
    } 
    else 
    {
        lcd.locate(0, 0);
        lcd.printf("Return 2");
    }
    wait(3);

    printf("Starting sending ping. \r\n");
    uint32_t reply_count = wifi.ping(ip, 5, 500, 32);
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Recieved:");
    lcd.locate(0, 1);
    lcd.printf("%d", reply_count);
    printf("Ping demo completed. \r\n");
    wifi.disconnect();
}