#include "mbed.h"
#include "reScale.h"

#define KP 0.8f
#define KI 1.0f
#define KD 0.01f
#define offset 0.02f


AnalogIn SETPOINT(A0);
AnalogIn TPS1(A2);
AnalogIn TPS2(A3);
Ticker flipper;
DigitalOut  controlLED(LED2); 
DigitalOut  IN1A(D10);
DigitalOut  IN2A(D8);
PwmOut TBI(D9);

//Timer t1;

//Serial device(PB_6, PB_7); // tx, rx
Serial device(USBTX, USBRX); // tx, rx

reScale _scale(0.0f,1.0f,0.09f,0.83f); 

float pwm=0, erro=0, proporcional=0, integrador=0;
float TPS1_VAL, SETPOINT_VAL=0, SETPOINT_scaled=0;
bool flag=0; 

void flip() 
{
    flag=!flag;
    controlLED=!controlLED;
}

void open()
{
    IN1A=1;
    IN2A=0;
}

void close()
{
    IN1A=0;
    IN2A=1;
}
    
int main() 
{   
    flipper.attach(&flip, 0.2);
    TBI.period(0.01f);
    
    IN1A=0;
    IN2A=0;
    
    while(1) 
    {   
        
    //t1.reset();
    //t1.start(); 
        
        TPS1_VAL = TPS1.read();
        SETPOINT_VAL = SETPOINT.read();
        
        SETPOINT_scaled = _scale.from(SETPOINT_VAL);
        
        if(SETPOINT_scaled < 0.185f)
        {
            close();
            erro =  TPS1_VAL - SETPOINT_scaled;        
            proporcional = erro * KP;
        }
        
        else
        {
            open();
            erro = SETPOINT_scaled - TPS1_VAL;        
            proporcional = erro * KP;
        }
                
        if(erro>1 || erro<-1)
        {
            //do nothing
        }
        
        else
        {
            integrador =  integrador + ((erro * KI)*0.01f);
        }
        
        if(integrador >=1)
        integrador = 1;
        
        if(integrador <=-1)
        integrador = -1;
        
                
        pwm = proporcional + integrador;
        TBI = pwm + offset;
        
        
        if(flag==1)
        {
            device.printf("\n\rPedal: %.4f",SETPOINT_scaled);
            device.printf("\n\rTPS: %.4f",TPS1_VAL);
            device.printf("\n\rErro: %.4f",erro);
            device.printf("\n\rPWM: %.4f",pwm);
            //device.printf("integrador: %f\n",integrador);
            //device.printf("proporcional: %f\n",proporcional);
            flag=0;
        }
        
        //t1.stop();
        //printf("O ciclo levou: %i uS \n\r", t1.read_us());
        wait(0.01);
    }
}