#include "mbed.h"

//-----------Pinos de saida (output)---------------
DigitalOut IN1A(D5);
DigitalOut IN2A(D4);
DigitalOut EN_A(D2);
DigitalOut IN1B(A0);
DigitalOut IN2B(A1);
DigitalOut EN_B(A4);
DigitalOut LED(PA_5);

//-----------Pinos de saida (input)---------------
DigitalIn SW(PC_13);

//----------Pinos de entrada analogica (ADC)------
AnalogIn   AXIS_X(A3);
AnalogIn   AXIS_Y(A5);

//---------Declaração de comunicação serial-------
Serial pc(USBTX, USBRX);

//---------Declaração de comunicação CAN-------
CAN can1(PB_8, PB_9);

//---------Declaração de interrupção para debug-------
Ticker flip;


//---------Dados em hexadecimal de cada mensagem-------
static char info =  0x55;
static char left =  0x01;
static char right = 0x02;
static char up =    0x03;
static char down =  0x04;
static char stop =  0x05;

//--------Rotina do debug--------------------------
void debug()
{
    LED =! LED;
}

//-------Rotina para setar os pinos na direção -X -------
void move_down()
{
    EN_A = 1;
    EN_B = 1;
    IN1A = 1;
    IN2A = 0;
    IN1B = 0;
    IN2B = 0;

}

//-------Rotina para setar os pinos na direção +X -------
void move_up()
{
    EN_A = 1;
    EN_B = 1;
    IN1A = 0;
    IN2A = 1;
    IN1B = 1;
    IN2B = 0;
}

//-------Rotina para setar os pinos na direção -Y -------
void move_left()
{
    EN_A = 1;
    EN_B = 1;
    IN1A = 1;
    IN2A = 1;
    IN1B = 0;
    IN2B = 0;
}

//-------Rotina para setar os pinos na direção +Y -------
void move_right()
{
    EN_A = 1;
    EN_B = 1;
    IN1A = 0;
    IN2A = 0;
    IN1B = 1;
    IN2B = 0;
}

//-------Rotina para desligar os motores de X e Y -------
void move_stop()
{
    EN_A = 0;
    EN_B = 0; 
}

int main() 
{   
    //---------Garante que não haverá curto na ponte H ao ligar----
    IN1A = 0;
    IN2A = 0;
    EN_A = 1;
    IN1B = 0;
    IN2B = 0;
    EN_B = 1;
    
    //-----atribuição dos dados as mensagens----------
    CANMessage msg(5, &info, 8, CANData, CANStandard);
    CANMessage msg_up(5, &up, 8, CANData, CANStandard);
    CANMessage msg_down(5, &down, 8, CANData, CANStandard);
    CANMessage msg_left(5, &left, 8, CANData, CANStandard);
    CANMessage msg_right(5, &right, 8, CANData, CANStandard);
    CANMessage msg_stop(5, &stop, 8, CANData, CANStandard);
    
    //----Pisca o led e envia via serial uma string-------
    LED = 1; 
    wait(0.5); 
    LED = 0; 
    wait(0.5); 
    pc.printf("Start\n");
    
    //-----Habilita a interrupção para debug--------------
    flip.attach(&debug, 0.5f);
    
    //---------Declaração de variaveis locais----------------
    float VAL_X = 0.0f, VAL_Y = 0.0f;
    
    while(1) 
    {
        
        //------Leitura do joystick nos eixos X e Y --------------
        VAL_X = AXIS_X.read();
        VAL_Y = AXIS_Y.read();
               
        //----Envia mensagem para +Y -----
        if(VAL_X > 0.7f)
        {
            //printf("\n\rRIGHT");
            if(can1.write(msg_right))
            {
                pc.printf("Direita enviada\n");            
            }
                
            else
            {
                pc.printf("Direita NAO enviada\n");                   
            }       
        }
        
        //----Envia mensagem para -Y -----
        if(VAL_X < 0.3f)
        {
            //printf("\n\rLEFT");
            if(can1.write(msg_left))
            {
                pc.printf("Esquerda enviada\n");            
            }
                
            else
            {
                pc.printf("Esquerda NAO enviada\n");                   
            }       
        }
        
        //----Envia mensagem para +X -----
        if(VAL_Y > 0.7f)
        {
            //printf("\n\rUP");
            if(can1.write(msg_up))
                {
                    pc.printf("Cima enviada\n");            
                }
                
                else
                {
                    pc.printf("Cima NAO enviada\n");                   
                }       
        }
        
        //----Envia mensagem para -X -----
        if(VAL_Y < 0.3f)
        {      
            //printf("\n\rDown");
            if(can1.write(msg_down))
            {
                pc.printf("Baixo enviada\n");            
            }
                
            else
            {
                pc.printf("Baixo NAO enviada\n");                   
            }       
        } 
        
        //----Se o joystick estiver em repouso, envia mensagem para parar os motores dos eixos--------
        if(((VAL_Y < 0.65f) && (VAL_Y > 0.45f)) && ((VAL_X < 0.65f) && (VAL_X > 0.45f)))
        {
            //printf("\n\rStop");
            if(can1.write(msg_stop))
            {
                pc.printf("Parada enviada\n");            
            }
                
            else
            {
                pc.printf("Parada NAO enviada\n");                   
            } 
        }     
    
        //-----Verifica se recebeu uma mensagem na CAN-------------
        if(can1.read(msg))
        {
            pc.printf("Mensagem recebida: %x\n", msg.data[0]);  
        }
        
        //------Se a mensagem for do tipo UP, então move para cima----
        if(msg.data[0] == up)
        {
            move_up();
            pc.printf("Cima recebida: %x\n", msg_up.data[0]);  
        }
        
        //------Se a mensagem for do tipo DOWN, então move para baixo----
        if(msg.data[0] == down)
        {
            move_down();
            pc.printf("Baixo recebida: %x\n", msg_down.data[0]);  
        }
        
        //------Se a mensagem for do tipo RIGHT, então move para direita----
        if(msg.data[0] == right)
        {
            move_right();
            pc.printf("Direita recebida: %x\n", msg_right.data[0]);  
        }
        
        //------Se a mensagem for do tipo LEFT, então move para esquerda----
        if(msg.data[0] == left)
        {
            move_left();
            pc.printf("Esquerda recebida: %x\n", msg_left.data[0]);  
        }
        
        //------Se a mensagem for do tipo STOP, então para os motores------   
        if(msg.data[0] == stop)
        {
            move_stop();
            pc.printf("Parada recebida: %x\n", msg_stop.data[0]);  
        }
        
        msg.data[0] = 0x00;//limpa a variavel
                
        wait_ms(10);//controla o envio/recebimento de mensagens
    }
}
