#include "mbed.h"

PwmOut myservo(D6);
AnalogIn pot(A0);
Serial pc(USBTX, USBRX); // tx, rx

float Map (float inVal, float inMin, float inMax, float outMin, float outMax);

float i=0.0f, x=0.0f;

int main() {    
    
    myservo.period(0.02f);
    
    //Required ESC Calibration/Arming sequence  
    
    //sends longest and shortest PWM pulse to learn and arm at power on
    myservo = 0.1; 
    wait(2.5);
    myservo = 0.05; 
    wait(2.5);
    myservo = 0.075; 
    wait(2.5);
     
    
    while(1){
    x = pot.read();
    i = Map(x, 0.0, 1.0, 0.05, 0.1); 
    myservo.write(i);
    pc.printf("control %f\n\r",i);    
    wait(0.2);
    }
}

float Map (float inVal, float inMin, float inMax, float outMin, float outMax)
{
    return ( (inVal - inMin)*(outMax - outMin)/(inMax - inMin) + outMin );
}