#include "mbed.h"
#include "string.h"
   
PwmOut pwm(A1);

AnalogIn sensor(A0);

DigitalOut led(LED1);

DigitalIn sw(USER_BUTTON);

//Serial pc(USBTX, USBRX);
Serial pc(PC_10, PC_11);

Timer t1;
            
                           
double   ERROR_MEASURE,
         KP = 0.00902,     //000.9702f, //0.0159f,
         KI = 0.000133,    //000.0013986f, //156.1257f,
         PROPORTIONAL,
         INTEGRAL,
         LAST_INTEGRAL,
         PI,
         TS = 0.5;
         
float TEMPERATURE_C = 0;

float SETPOINT = 210.0f;


void pi_control(void); 
void calc_celsius(void); 
void le_k(void);

int main()
{
     
     pc.baud(115200);
     pc.attach(&le_k);
     
     pwm.period_us(1000); //1KHz
     int MS=0;
     
     pwm.write(0.1f);
     int play = 0;
     while(play == 0) 
     {
        calc_celsius();
        pc.printf("Temp %.2f\r",TEMPERATURE_C);
        if((sw == 0) && (play == 0)) 
        {
            wait_ms(300);
            if((sw == 0) && (play == 0)) 
            {
                play = 1;
                wait_ms(1000);
            }
        }
    }
          
     while(1)                                  
     {
        //t1.stop();
        //pc.printf("%i\r",t1.read_us());
        //t1.reset();
        //t1.start();
        calc_celsius();
        pi_control();
        pc.printf("Temp: %.2f %i\r",TEMPERATURE_C, MS);
        MS +=500; 
        //pc.printf("PI: %f\r",PI); 
     } 

} 

void pi_control()    
{      
    ERROR_MEASURE = SETPOINT - TEMPERATURE_C; //calcula o erro

    PROPORTIONAL = ERROR_MEASURE * KP; //calcula a parcela proporcional

    INTEGRAL = LAST_INTEGRAL + (ERROR_MEASURE * KI * TS); //calcula a parcela integradora
    
    //if(integral >  1.0f) integral =  1.0f;//anti wind up
    //if(integral < -1.0f) integral = -1.0f;
    
    PI = PROPORTIONAL + INTEGRAL ; //soma as parcelas
    
    //if(PID > 1.0f) PID = 1.0f; //nao deixa os valores ultrapasssarem o range do pwm de 0.0 a 1.0 (equivale a 0 - 100%)
    //if(PID < 0.0f) PID = 0.0f;
   
    pwm = PI; //escreve a saida de pwm
    
    LAST_INTEGRAL = INTEGRAL;
} 

void calc_celsius()
{
    float average = 0;
    for(int i = 0; i < ((TS * 1000.0) - 6); i++) //-6 pois é o tempo de ciclo do programa, assim compensando para nao interferir em Ts
    {
        average += sensor.read();
        wait_ms(1);
    }
    
    float adc_sensor = (average / ((TS * 1000.0) - 6)) * 4096.0f; //-6 pois é o tempo de ciclo do programa, assim compensando para nao interferir em Ts
    average = 0.0f;
    
    float R_sensor = 10000.0f * adc_sensor / (4095.0f - adc_sensor);
    float div = R_sensor/100000.0f;
    float x_log = log(div);
    float log_1_b = x_log * 0.000253165f;
    float k2 = log_1_b + 0.003354016f;
    float tk = 1.0f / k2;
    
    TEMPERATURE_C = tk - 273.15f;
}



     
void le_k()
{
    char c[20];
    memset(c,NULL,20);
    
    int i = 0;
    
    while(c[i-1] != '\r')
    {
        c[i] = pc.getc();
        i++;
    }
                    
    char valor[8];
            
    valor[0] = c[1];
    valor[1] = c[2];
    valor[2] = c[3];
    valor[3] = c[4];
    valor[4] = c[5];
    valor[5] = c[6];
    valor[6] = c[7];
    valor[7] = c[8];
            
    //pc.printf(valor);
            
    if(c[0] == 'P') //ajusta Kp
    {
        KP = atof(valor); 
        pc.printf("\n\nkp = %f\n\r\n",KP);
    }
           
    if(c[0] == 'I') //ajusta Ki
    {
        KI = atof(valor); 
        pc.printf("\n\nki = %f\n\r\n",KI);
    }
            
    if(c[0] == 'T') //ajusta Kd
    {
        TS = atof(valor); 
        pc.printf("\n\nTs = %f\n\r\n",TS);
    }  
        
    if(c[0] == 'S') //ajusta o SETPOINT
    {
        SETPOINT = atof(valor); 
        pc.printf("\n\nSetpoint = %f\n\r\n",SETPOINT);
    }   
    
    wait_ms(2000);       
}

