#include "mbed.h"

Ticker flipper;

DigitalOut  controlLED(D13); 
DigitalOut  inj_1(D2);
DigitalOut  inj_2(D3);
DigitalOut  inj_3(D4);
DigitalOut  inj_4(D5);

//Timer t1;
Timer t2;

Serial device(USBTX, USBRX); // tx, rx

bool flag;
float RPS = 0;
int inj_time = 10000;

void flip() 
{
    flag=!flag;
    controlLED=!controlLED;
}

void set_parameters()
{
    char c[8];
    char parameter = 0x00;
    int i = 0;
    int value;
    int RPM;
    
    parameter = device.getc();
       
    if((parameter == 'T')  || (parameter == 'R')) //T or R
    {
        while(c[i-1] != '\n')
        {
            c[i] = device.getc();
            i++;         
        }
    }
    
    else
    {
        device.printf("Invalid command. Txxxxx to set injection time, Rxxxxx to set RPM\n\r");
        device.fsync();
    }
       
    if(parameter == 'T') 
    {      
        value = atoi(c);
        inj_time = value;
                    
        device.printf("Inj Time %i uS\n\r",inj_time);
    } 
    
    if(parameter == 'R')  
    {     
        value = atoi(c);
        
        RPM = value;
            
        RPS = RPM / 60.0f;
            
        RPS = RPS * 2; //multiplicador por 2 pois um ciclo otto são 2 voltas
        
        RPS = 1.0f / RPS;       

        flipper.attach(&flip, RPS);
           
        device.printf("%f S\n\r",RPS);
    } 
}

int main() 
{   
    bool valid_pulse;
    int inj_counter = 1;
    
    RPS = 1.0f;
    flipper.attach(&flip, RPS);
    
    device.printf("Start\n\r");
    
    while(1)    
    {   
        
    //t1.reset();
    //t1.start();     
            
        if(device.readable())
        {
            set_parameters();   
        }
        
        
        if(inj_counter > 4)
        {
            inj_counter = 1;
        }
        
        if(t2.read_us() > inj_time)
        {   
            t2.stop();
            inj_1 = 0;
            inj_2 = 0;
            inj_3 = 0;
            inj_4 = 0;
        }
        if((inj_counter == 1) && (valid_pulse == 1))
        {
            valid_pulse = 0; 
            inj_1 = 1;
            inj_2 = 0;
            inj_3 = 0;
            inj_4 = 0;
            t2.reset();
            t2.start();
        }
         
        if((inj_counter == 2) && (valid_pulse == 1))
        {
            valid_pulse = 0; 
            inj_1 = 0;
            inj_2 = 0;
            inj_3 = 1;
            inj_4 = 0;
            t2.reset();
            t2.start();
        }
        
        if((inj_counter == 3) && (valid_pulse == 1))
        {
            valid_pulse = 0; 
            inj_1 = 0;
            inj_2 = 0;
            inj_3 = 0;
            inj_4 = 1;
            t2.reset();
            t2.start();
        }
        
        if((inj_counter == 4) && (valid_pulse == 1))
        {
            valid_pulse = 0; 
            inj_1 = 0;
            inj_2 = 1;
            inj_3 = 0;
            inj_4 = 0;
            t2.reset();
            t2.start();
        }
        
        
        if(flag==1)
        {
            inj_counter++;
            flag=0;
            valid_pulse = 1;
        }
        
        //t1.stop();
        //printf("O ciclo levou: %i uS \n\r", t1.read_us());
    }
}