/*****************************************************************
* Projeto de uma unidade controladora de motor ciclo otto 
* 4 cilindros em modo sequencial, tanto injeção como ignição
* PMS em 15º dente
*
* Matéria de eletrônica Embarcada
*
* Insper instituto e pesquisa
*
* Autor: Marcelo Costanzo Miranda
* Data: 20/03/2019
**************************************************************/

#include "mbed.h"

#define first_turn 0
#define second_turn 1

//------------------Pino para o sinal de rotação-----------------------------
InterruptIn crank_pulse(D7);

//-----------------Debug para confirmação da leitura da falha da roda fônica-
DigitalOut LED(LED2);

//-----------------Saidas de injeção--------------------------------------
DigitalOut  inj_1(D2);
DigitalOut  inj_2(D3);
DigitalOut  inj_3(D4);
DigitalOut  inj_4(D5);

//----------------Saidas de injeção-------------------------------------
DigitalOut  Splug_1(D8);
DigitalOut  Splug_2(D9);
DigitalOut  Splug_3(D10);
DigitalOut  Splug_4(D11);

//----------------Timers----------------------------------------
Timer t1;//leitura da velocidade do virabrequim
Timer t2;//tempo de injeção
Timer t3;//tempo de ignição

//Ticker flipper;

Serial device(USBTX, USBRX); // tx, rx

//--------------Variaveis inteiras------------------------------
int crank_pulse_period = 0;
int crank_pulse_period_old = 0;
int tooth_number = 0;
int inj_time = 2500;
int dwell_time = 3000;
int angle_ignition_timing = 18;
int tooth_ignition_timing = 0;
int total_tooth_ignition_timing = 0;

/*
float rps = 0;
float mS_degree = 0;
float uS_degree = 0;
*/

//--------------Variaveis booleanas--------------------------------
bool flag = 0;
bool cicle_turn = first_turn;
bool valid_injection_1 = 0;
bool valid_injection_2 = 0;
bool valid_injection_3 = 0;
bool valid_injection_4 = 0;
bool valid_ignition_1 = 0;
bool valid_ignition_2 = 0;
bool valid_ignition_3 = 0;
bool valid_ignition_4 = 0;

//--------------Rotina de leitura da velocidade do virabrequim-----
void crank_read()
{
    tooth_number++;
    t1.stop();
    crank_pulse_period_old = crank_pulse_period;
    crank_pulse_period = t1.read_us();
    t1.reset();
    t1.start(); 
}
/*
void flip()
{
    flag=!flag;
    LED=!LED;
}
*/

//-----------------Inicio da rotina principal-------------------------------
int main() 
{     
    
    crank_pulse.rise(&crank_read);//habilita a interrupção externa
    
    //flipper.attach(&flip, 0.01);
           
    while(1) 
    {
        //-----------A rotina a seguir verifica se ocorreu a leitura da falha-----------
        if((crank_pulse_period >= (crank_pulse_period_old * 2)) && (tooth_number >= 58))
        {
            tooth_number = 1;//caso ocorra, reinicia a contagem dos dentes
            cicle_turn = !cicle_turn;//alterna entre primeira e segunda volta do ciclo
            
            //caso seja a primeira volta, valida as injeções e iginições necessárias
            if(cicle_turn == first_turn)
            {
                valid_injection_1 = 1;
                valid_injection_2 = 0;
                valid_injection_3 = 1;
                valid_injection_4 = 0;
                valid_ignition_1 = 1;
                valid_ignition_2 = 1;
                valid_ignition_3 = 0;
                valid_ignition_4 = 0;
            }
            //caso seja a segunda volta, valida as injeções e iginições necessárias
            else
            {
                valid_injection_1 = 0;
                valid_injection_2 = 1;
                valid_injection_3 = 0;
                valid_injection_4 = 1;
                valid_ignition_1 = 0;
                valid_ignition_2 = 0;
                valid_ignition_3 = 1;
                valid_ignition_4 = 1;
            }
        }
        //-----------Fim da rotina de verificar se ocorreu a leitura da falha-----------
        
        /*
        else
        {
            rps = crank_pulse_period * 60.0f;
            rps = rps / 1000.0f;
            rps = rps / 1000.0f;
            rps = 1.0f * rps;
            mS_degree = rps * 360.0f;
            mS_degree = mS_degree / 1000.0f;
            uS_degree = mS_degree / 1000.0f;
        }
        */
        
        //---------------Debug da falha da roda fônica------------------------
        if(tooth_number == 58)
        {
            LED = 1;
        }
        
        else
        {
            LED = 0;            
        }       
        
        
     //----------Caso o timer tenha alcançado o tempo de injeção, desliga o injetor----------------------------
        if(t2.read_us() >= inj_time)
        {   
            t2.stop();
            inj_1 = 0;
            inj_2 = 0;
            inj_3 = 0;
            inj_4 = 0;
        }
        
        //--------Caso o virabrequim esteja entre 0-180°(15-45dente), ocorre a injeção no cilinro 1
        if(((tooth_number >= 15) && (tooth_number < 45)) && (cicle_turn == first_turn))
        {
            if(valid_injection_1 == 1)
            {
                valid_injection_1 = 0; 
                inj_1 = 1;
                inj_2 = 0;
                inj_3 = 0;
                inj_4 = 0;
                t2.reset();
                t2.start();
            }
        }
        
        //--------Caso o virabrequim esteja entre 180-360°(>45dente), ocorre a injeção no cilinro 3
        if((tooth_number >= 45) && (cicle_turn == first_turn))
        {
            if(valid_injection_3 == 1)
            {
                valid_injection_3 = 0; 
                inj_1 = 0;
                inj_2 = 0;
                inj_3 = 1;
                inj_4 = 0;
                t2.reset();
                t2.start();
            }
        }
        
        //--------Caso o virabrequim esteja entre 360-540°(15-45dente), ocorre a injeção no cilinro 4
        if((tooth_number >= 15) && (tooth_number < 45) && (cicle_turn == second_turn))
        {
            if(valid_injection_4 == 1)
            {
                valid_injection_4 = 0; 
                inj_1 = 0;
                inj_2 = 0;
                inj_3 = 0;
                inj_4 = 1;
                t2.reset();
                t2.start();
            }
        }
        
        //--------Caso o virabrequim esteja entre 540-720°(>45dente), ocorre a injeção no cilinro 2
        if((tooth_number >= 45) && (cicle_turn == second_turn))
        {
            if(valid_injection_2 == 1)
            {
                valid_injection_2 = 0; 
                inj_1 = 0;
                inj_2 = 1;
                inj_3 = 0;
                inj_4 = 0;
                t2.reset();
                t2.start();
            }
        } 
        
        //---------------------------Fim da rotina de injeção------------------------------------------------------------------------------------ 
        
        
        tooth_ignition_timing = angle_ignition_timing / 6; //calcula o numero de dentes proporcional ao angulo de avanço de ignição
                                                           //cada dente tem 6 graus, então graus/6 = n-dentes
                                                           
        total_tooth_ignition_timing = (dwell_time / crank_pulse_period) + tooth_ignition_timing; //calcula o numero de dentes de avanço, para iniciar a carga da bobina considerando o avaço de ignição
        
        //----------Caso o timer tenha alcançado o tempo de carga, desliga a bobina----------------------------
        if(t3.read_us() > dwell_time)
        {   
            t3.stop();
            Splug_1 = 0;
            Splug_2 = 0;
            Splug_3 = 0;
            Splug_4 = 0;
        }
        
        //--------Carga(dwell) + avanço, no ciclo de compressão do cilindro 1
        if((tooth_number >= 45 - total_tooth_ignition_timing) && (cicle_turn == first_turn))
        {
            if(valid_ignition_1 == 1)
            {
                valid_ignition_1 = 0; 
                Splug_1 = 1;
                Splug_2 = 0;
                Splug_3 = 0;
                Splug_4 = 0;
                t3.reset();
                t3.start();
            }
        }
        
        //--------Carga(dwell) + avanço, no ciclo de compressão do cilindro 2
        if(((tooth_number >= 15 - total_tooth_ignition_timing) && (tooth_number < 45 - total_tooth_ignition_timing)) && (cicle_turn == first_turn))
        {
            if(valid_ignition_2 == 1)
            {
                valid_ignition_2 = 0; 
                Splug_1 = 0;
                Splug_2 = 1;
                Splug_3 = 0;
                Splug_4 = 0;
                t3.reset();
                t3.start();
            }
        }
        
        //--------Carga(dwell) + avanço, no ciclo de compressão do cilindro 4
        if((tooth_number >= 45 - total_tooth_ignition_timing) && (cicle_turn == second_turn))
        {
            if(valid_ignition_4 == 1)
            {
                valid_ignition_4 = 0; 
                Splug_1 = 0;
                Splug_2 = 0;
                Splug_3 = 0;
                Splug_4 = 1;
                t3.reset();
                t3.start();
            }
        } 
        
        //--------Carga(dwell) + avanço, no ciclo de compressão do cilindro 3
        if((tooth_number >= 15 - total_tooth_ignition_timing) && (tooth_number < 45 - total_tooth_ignition_timing) && (cicle_turn == second_turn))
        {
            if(valid_ignition_3 == 1)
            {
                valid_ignition_3 = 0; 
                Splug_1 = 0;
                Splug_2 = 0;
                Splug_3 = 1;
                Splug_4 = 0;
                t3.reset();
                t3.start();
            }
        }
        //---------------------------Fim da rotina de ignição------------------------------------------------------------------------------------ 
    
    }
}