#include "mbed.h"
#include "reScale.h"

#define tole_min 10 //tolerancia minima em km/h de destracionamento
#define tole_max 60 //tolerancia maxima em km/h de destracionamento
#define ndentes 60  //numero de dentes do sensor 

InterruptIn motora(D2);
InterruptIn movida(D3);

DigitalOut ign(LED2);

PwmOut boost(D9);

Timer t1;
Timer t2;
Ticker flipper;

//Serial pc(USBTX, USBRX); // tx, rx
Serial device(PC_10, PC_11);  // tx, rx

reScale deltapwm(tole_min,tole_max,0.0,1.0); //para escalar o destracionamento em pwm para solenoide da turbina 
reScale velogauge1(45,260,0,1.0);
reScale velogauge2(tole_min,tole_max,0.0,1.0);

//ORGANIZAR AS VARIAVEIS, GLOBAIS PARA POSSIVEIS LOCAIS
//----------variaveis globais-------------------------------------------------
float t_motora=0, t_movida=0, pneu_largura,pneu_perfil,pneu_aro, pwmturbo=0, t_movidabkp, t_motorabkp;
float perimetro_movida, perimetro_motora, raio_dinamico, delta=0, vel_movida=0, vel_motora=0;
char command[17], i=0, X = 255;
uint16_t val1, val16, val256, val4096, veluint;
bool flag=0, flagbff;


void livre()//rotina de input capture para a roda movida 
{
    t2.stop();
    t_movida = t2.read_us();
    t2.reset();
    t2.start();   
}

void tracao() //rotina de input capture para a roda motora 
{
    t1.stop();
    t_motora = t1.read_us();
    t1.reset();
    t1.start();   
}

void flip() //time para envio das infos pela serial
{
    flag=!flag;
}

void flushSerialBuffer(void) //rotina para limpar o buffer da serial
{ 
    char char1 = 0; 
    while (device.readable()) 
    { 
        char1 = device.getc();
    } return; 
}

int main() 
{
    device.baud(115200);  
    wait(1.0);
    
    flushSerialBuffer();
        
    motora.fall(&tracao);  //habilita a interrupt de borda de descida para a roda motora
    movida.fall(&livre);   //habilita a interrupt de borda de descida para a roda movida
    flipper.attach(&flip, 0.1); //habilita a interrupt que ocorre a 10Hz para envio das infos
    
    boost.period(0.05f); //set da frequencia do pwm para 20Hz
       
    while(1) 
    {    
        if(device.readable()) //verifica se há algo no buffer da serial
        {
            flipper.detach(); //desabilita o envio das infos
            ign = !ign;        //troca o estado do led, fins de depuração
            for(i=0;i<17;i++) //le os 17 caracteres na serial
            {  
                command[i]=device.getc();
            }   
            
            if(command[1]==0x03) //caso a pagina 3 seja lida, motora
            {   
                val1  = command[6]<<8; 
                val16 = command[5];
                pneu_largura = val1 + val16;//calcula a largura do pneu
            
                val1  = command[10]<<8;
                val16 = command[9];
                pneu_perfil = val1 + val16;//calcula o perfil do pneu
            
                val1  = command[14]<<8;
                val16 = command[13];
                pneu_aro = val1 + val16;//calcula o aro do pneu
                
                //a seguir calcula o perimetro em metros da roda motora
                pneu_perfil = pneu_perfil / 100;
                raio_dinamico = pneu_largura * pneu_perfil;
                pneu_aro = pneu_aro * 25.4;
                raio_dinamico = raio_dinamico + pneu_aro;
                perimetro_motora = raio_dinamico * 3.14; //resultado em milimetros
                perimetro_motora = perimetro_motora / 1000; //converter em metros
            }
            
            if(command[1]==0x04)//caso a pagina 3 seja lida, movida
            {   
                val1  = command[6]<<8;
                val16 = command[5];
                pneu_largura = val1 + val16;//calcula a largura do pneu
            
                val1  = command[10]<<8;
                val16 = command[9];
                pneu_perfil = val1 + val16;//calcula o perfil do pneu
            
                val1  = command[14]<<8;
                val16 = command[13];
                pneu_aro = val1 + val16;//calcula o aro do pneu
                
                //a seguir calcula o perimetro em metros da roda movida
                pneu_perfil = pneu_perfil / 100;
                raio_dinamico = pneu_largura * pneu_perfil;
                pneu_aro = pneu_aro * 25.4;
                raio_dinamico = raio_dinamico + pneu_aro;
                perimetro_movida = raio_dinamico * 3.14; //resultado em milimetros
                perimetro_movida = perimetro_movida / 1000; //converter em metros
            }
            flipper.attach(&flip, 0.1); //habilita o envio das infos
        } 
         
        //para garantir que ao parar de receber pulsos, a tela não fique mostrando a ultima velocidade  
        if(t_motora > 350000)
        t_motora = 0;
        
        //para garantir que ao parar de receber pulsos, a tela não fique mostrando a ultima velocidade 
        if(t_movida > 350000)
        t_movida = 0;
        
        //calcula a velocidade da roda motora         
        t_motorabkp = t_motora;
        t_motorabkp = t_motorabkp * ndentes;
        t_motorabkp = t_motorabkp / 1000000;
        vel_motora = perimetro_motora / t_motorabkp;
        vel_motora = vel_motora * 3.6;// m/s para km/h
        
        //calcula a velocidade da roda movida
        t_movidabkp = t_movida;
        t_movidabkp = t_movidabkp * ndentes;
        t_movidabkp = t_movidabkp / 1000000;
        vel_movida = perimetro_movida / t_movidabkp;
        vel_movida = vel_movida * 3.6;// m/s para km/h
        
        
        delta = vel_motora - vel_movida;// calcula o quanto o veiculo esta destracionando
                
        if(delta<=0)    //garante que não exista valores negativos de destracionamento
        {
            delta=0;
        }
        
        pwmturbo = deltapwm.from(delta);  //escala o valor de destracionamento para o pwm da solenoide
        
        if(pwmturbo<=0) //garante que não exista valores negativos de pwm
        {
            pwmturbo = 0;
        }
          
        boost.write(pwmturbo); //set do duty cycle 0.0 - 1.0, valor float
        pwmturbo = pwmturbo * 100; //apos o uso da variavel, converto em porcentagem para exibir no display
        
        if(flag==1) //caso tenha passado 100mS, envia as infos
        {   
            if(pwmturbo>=1)//troca a cor do icone no display para vermelho
            {
                device.printf("vis p0,1");
                device.printf("%c%c%c",X,X,X);     
            }
            else         //troca a cor do icone no display para verde
            {
                device.printf("vis p1,1");
                device.printf("%c%c%c",X,X,X);       
            }
            device.printf("n0.val=%.f",vel_movida);
            device.printf("%c%c%c",X,X,X); 
            device.printf("n1.val=%.f",delta);
            device.printf("%c%c%c",X,X,X); 
            device.printf("n8.val=%.f",pwmturbo);
            device.printf("%c%c%c",X,X,X); //caracter para fim de info, necessario para o display receber a info 
            flag=0;   
        }        
    }
}
