#include "mbed.h"

/* Declara o uso da serial padrao da placa nucleo */
Serial pc(USBTX,USBRX);

/* Declara o uso do led nativo da nucleo */
DigitalOut led(LED1);

/* Prototipo da funcao para imprimir em binario */
char* int2bin(int value, char* buffer, int bufferSize);

/* Delcara a variavel e atribui o lador 33 (caracter !) */
int thisByte = 33;

int main()
{
    while(1) 
    {
        pc.printf("%c",thisByte); //imprimi na forma pura, ou seja, o proprio caracter
        
        pc.printf(", dec: ");
        pc.printf("%i",thisByte); //imprimi na forma decimal, ou seja, o numero do caracter na base 10

        pc.printf(", hex: ");
        pc.printf("%X",thisByte);//imprimi na forma hexadecimal, ou seja, na base 16

        pc.printf(", oct: ");
        pc.printf("%o",thisByte);//imprimi na forma octal, ou seja, na base 8

        pc.printf(", bin: ");
        char binaryBuffer[17];  //buffer para armazenar a string com o valor binario
        char* binString = int2bin(thisByte, binaryBuffer, 17) ; //converte para binario
        pc.printf("%s\n\r",binString);//imprimi na forma binaria, ou seja, na base 2

        /* Se o byte impresso foi o 126 ('~'), para o ciclo */
        if (thisByte == 126)
        {    
            while (true) 
            {
                continue;
            }
        }
        
        thisByte++;//avança apra o proximo caracter

    }
}

/* Funcao para imprimir em binario */
char* int2bin(int value, char* buffer, int bufferSize)
{
    char *nextChar = buffer + bufferSize-1;            // location to write the least significant bit
 
    *nextChar = 0;  // add the null terminator
 
    do {
        nextChar--;
        (value & 1) ? *nextChar  = '1' : *nextChar  = '0'; // if set set to '1' else '0'
        value = value>>1;
        if (nextChar == buffer)
          break;
    } while (value);
    return nextChar;
}
