#include "mbed.h"
#include "TextLCD.h"
#include "PinDetect.h"

DigitalOut myled(LED1);

DigitalOut buzzer(p24);
PinDetect pb1(p23); // Increase minutes
PinDetect pb2(p22); // Decrease minutes
PinDetect pb3(p21); // Start / pause


//TextLCD(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7, LCDType type = LCD16x2);
// Note: VCC=5V, V0=0V, via 330 resistor)
TextLCD lcd(p15, p16, p17, p18, p19, p20);

Ticker flipper;
Timeout wait_time;

volatile int start = 0;
volatile int t1s = 0;

volatile unsigned char a = 0;
volatile unsigned char b = 0;
volatile unsigned char c = 0;

volatile char seconds = 0;
volatile char minutes = 25;
volatile char hours = 0;
volatile char alarm = 1;   // alarm set on/off ==> enables buzzer
 
void update_lcd() {
    lcd.locate (0,1);
    lcd.printf("%02d:%02d:%02d  %2x%2x%2x",hours, minutes, seconds,a,b,c);
}

void flip() {
    t1s = 1;
}

void count_down(){
  
  if(seconds == 0 && minutes == 0 && hours == 0)
      return;
  
  if(seconds != 0) {
      seconds -= 1;
      return;
  }
  
  if(minutes != 0){
      minutes -= 1;
      seconds = 59;
      return;      
  }
  
  if(hours != 0){
      hours -= 1;
      minutes = 59;
      seconds = 59;
      return;    
  }    
}


// Buzzer beep for t seconds
void beep(float t) {
    buzzer = 1;
    wait(t);
    buzzer = 0;
}

void beepn(int i, float t) {
    while(i --){
        buzzer = 1;
        wait(t);
        buzzer = 0;
        wait(t);
    }
}

// Callback routine is interrupt activated by a debounced pb2 hit
void pb1_hit_callback (void) {
    minutes++;
}
// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void) {
    minutes--;
}
// Callback routine is interrupt activated by a debounced pb3 hit
void pb3_hit_callback (void) {
    start = (start + 1) & 0x01;
}


int main () {   
        
    // Clean screen
    lcd.cls();
    lcd.printf("Countdown");

    beep(0.1); // init buzzer
    
    update_lcd(); 
                  
    flipper.attach(&flip, 1.0); // interval 1 second
  
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    
    while(1) {
        if (t1s){
          t1s = 0;
          myled = !myled;
          
          if(start)
              count_down();
              
          update_lcd();
          
          // Last 5 seconds
          if(seconds > 0 && seconds <= 5 && minutes == 0 && hours == 0) {
              beep(0.2);
          }
          // Countdown finished
          else if(seconds == 0 && minutes == 0 && hours == 0) {
            flipper.detach();
            beepn(5, 0.2);
          }
         }           
   }
}