#include "mbed.h"

enum{
    led_permoff,
    blink,
    };
InterruptIn int_puls_start(PTD2);
DigitalOut led (LED1);
//defino funciones
void timer_antirrebote(void);
void detect(void);
void blinker(void);
//defino variables
unsigned int puls=0,end_cont=0;//end_cont es la variable que indica la finalizacion del contador, puls es la variable que simula un pulsador con retencion
unsigned int cont_antirrebote;
unsigned char state;
unsigned int cont_blink;
Ticker tim;


int main() {
    tim.attach(&timer_antirrebote,0.001);//configuro timer a 1ms
    int_puls_start.fall(&detect);//activo interrupcion por flanco descendente
    
    while(1) {  
    blinker();
}
}

void blinker(){
    if (end_cont){//se ejecuta si termina el contador del antirrebote
            end_cont=0;
            if(int_puls_start.read()==0){//si el pulsador se apreto se cambia la variable a
                if(puls==0)
                    puls=1;
                else
                    puls=0;
                    }
        }
    switch(state){
        case led_permoff:
            led=1;//led apagado permanentemente
            if(puls==1)
                state=blink;
            break;
        
        case blink:
        if(puls==0)
            state=led_permoff;
        if (cont_blink==0){//se produce el blinkeo del led
            if(led==0)
                led=1;
            else
                led=0;
            cont_blink=500;
            }
        break; 
        } 
    }

void detect(){//al detectarse la interrupcion se inicia el contador del antirrebote
    if (cont_antirrebote==0 )
        cont_antirrebote=20;
    
}
void timer_antirrebote(){//funcion de timer
        if (cont_antirrebote>0){
            cont_antirrebote--;
            if(!cont_antirrebote)end_cont=1;
        }
        if (cont_blink>0)
            cont_blink--;
        
}