#include "mbed.h"
enum{
    leo_pos,
    uno,
    cero,
    detect_v,
    cero_1,
    cero_2,
    viol,
    muestro,
    };
AnalogOut salida(PTE30);
 
unsigned char state;
unsigned int bit;
unsigned char cant_uno;//cant de unos previos(al llegar a 10 se resetea)
unsigned char cant_unov;//cant de unos previos desde la ultima violacion
unsigned char detect;//variable que indica si se detecto una violacion
unsigned char bit_b;//identifica la polaridad que debera tener el bit "v"
unsigned char cont_v=0;//cuenta la cantidad de bits desde el bit b para poder definir el v
unsigned int in[16]={1,1,1,0,0,0,0,0,0,0,0,0,1,0,1,0};//Se define el vector de entrada
float out[16];//Se define el vector de salida
unsigned char aux_cont;
Ticker tim;
void timer (void);


void codificacion(void);

int main() {
    tim.attach(&timer,0.001);
    
    while(1) {
    codificacion();    
    }
}

void codificacion(){
    switch (state){
        case leo_pos://estado en donde se lee el bit de entrada
            if (bit==16){//resetea las variables luego de codificar 16 bits
                cant_uno=0;
                cant_unov=0;
                cont_v=0;
                bit=0;
                state=muestro;
                break;}
            if(in[bit]==0)//Detecta el cero en la entrada
                state=cero;
            else
                state=uno;//Detecta el uno en la entrada
            break;
            
        case uno://estado en donde se define la polaridad del "1"
            cant_uno++;
            cant_unov++;
            if(cant_uno%2==0)//Se alterna la polaridad de los unos 
                out[bit]=0;
            else
                out[bit]=1;
            if(cant_uno==10)
                cant_uno=0;
            state=leo_pos;
            bit++;
            break;
        
        case cero://se detecta si el cero debe ser "b"
            if (in[bit+1]+in[bit+2]+in[bit+3]==0 && detect==0)//Detecta si hay 4 ceros seguidos
                state=detect_v;
            else
                state=cero_1;
            break;
        
        case detect_v:
        
            if(cant_unov%2==0){//Se define la polaridad del bit B
                if(out[bit-1]==1){
                    out[bit]=0;
                    bit_b=2;}
                if(out[bit-1]==0){
                    out[bit]=1;
                    bit_b=1;}
                if(out[bit-1]==0.5){
                if(cant_uno%2==0){
                    out[bit]=1;
                    bit_b=1;
                    }
                else {
                    out[bit]=0;
                    bit_b=2;
                    }
                    }
                    }
            else 
                out[bit]=0.5;
            
            state=leo_pos;
            cont_v++;
            detect=1;
            cant_unov=0;
            bit++;
            break;
            
        case cero_1://estado en el que se distingue entre un cero y un bit "v"
            if (detect==1 && cont_v==3)
                state=viol;    
            else
                state=cero_2;
            break;
        
        case cero_2:
            out[bit]=0.5;//se asigna el "0" a la salida
            state=leo_pos;
            if (cont_v>0)
                cont_v++;
            bit++;
            break;
            
        case viol://Se asigna el valor del bit V
            if(bit_b==0){
                    if(cant_uno%2==0)
                        out[bit]=0;
                    else
                        out[bit]=1;
                    }
            if(bit_b==1)
                out[bit]=1;
            if(bit_b==2)
                out[bit]=0;
            detect=0;
            cont_v=0;
            bit_b=0;
            state=leo_pos;
            bit++;
            break;
        
        case muestro://luego de cargar las 16 posisiones en el vector de salida , se saca esta informacion por una pata del micro a traves de un DAC
            if(bit==16){
                bit=0;
                state=leo_pos;
                salida = 0.5;
                break;}
            
            if(aux_cont==1){
                salida = out[bit];
                bit++;
                aux_cont=0;
                }
            break;   
        }
        }

void timer(){
    if(aux_cont==0)
        aux_cont=1;
    }