#include "mbed.h"
/** A test-class MyLed.
* Used for led on/off and status.
*
* Example:
* @code
* #include "mbed.h"
* #include "MyLed.h"
*
* MyLed myled2(LED2); // Instanziierung des Objekts
*
* int main() {
* myled2.ledOn(); // Zugriff auf die Methode über "."-Operator
* myled2.printStatus();
* wait_ms(500);
* myled2.ledOff();
* }
* @endcode
*/
class MyLed {
    public:
    /** Create a LED - DigitalOut connected to the specified pin
*
* @param pin DigitalOut pin to connect to
*/
// Konstruktor
    MyLed(PinName led) : _led(led) { // Initalisierungsliste
        _led = 0; // Initialisierung mit 0
}
// Methodenprototyledg
/** Set the output to 1 (int)
*
* @param value An integer specifying the pin output value,
* 0 for logical 0, 1 (or any other non-zero value) for logical 1
*/
    void ledOn(void);
    void ledOff(void);
    void printStatus(void);
    private:
    DigitalOut _led;
};