#include "mbed.h"
#include "SDFileSystem.h"
#include "x_nucleo_iks01a1.h"
#include "INTERFACE.h"
#include "DATA_LOGGER.h"
#include "math.h"

#define FLIGHMODE 1 // à 0 il n'y à aucun affichage sur tera term
Ticker ticker;

bool canlog = 0;
void INTERRUPTION(void);
DigitalOut L0(LED1);  // led L0
void automate();

short LO=0;
Timer TIMER_SEPARATION;
Timer TIMER_PARACHUTE;
short leds;
short erreur;
short ALTITUDE = 3374;

int main(void) {
  ticker.attach(&INTERRUPTION, 1);
  
  while(1){
    automate();
  }
  
}

void automate(void){
    
    typedef enum {TEST=0, COUNT=1, WAIT_SEPARATION=2, EJECTION=3, WAIT_PARACHUTE=4, PARACHUTE=5, AUTO_PILOTE=6, LED=7, ARRET=8} type_etat;
    type_etat etat_actuel;
    static type_etat etat_futur=TEST;
    // gestion des entrees
    // -------------------
    // gestion du diagramme de transition
    // ----------------------------------
    etat_actuel = etat_futur;
    switch(etat_actuel) {
       case TEST :
            
            if (erreur==0) etat_futur = COUNT;
            break;
        case COUNT :
            
            
            if (LO==1) etat_futur = WAIT_SEPARATION;
            break;
        case WAIT_SEPARATION :
        
             if(TIMER_SEPARATION.read()>5) {
                etat_futur = EJECTION;   //66s IRL
                }
            break;
        case EJECTION :

            etat_futur = WAIT_PARACHUTE;
            break;
        case WAIT_PARACHUTE :
            
            if(TIMER_PARACHUTE.read()>6) etat_futur = PARACHUTE;  //   84s IRL
            break;
        case PARACHUTE :
            
            if (ALTITUDE <3375) etat_futur = AUTO_PILOTE;
            break;
        case AUTO_PILOTE :
            
            if(leds==3) etat_futur = LED;
            break;
        case LED :
        
            etat_futur = ARRET;
            break;        
    }
    
    // gestion des sorties
    // -------------------
    switch(etat_actuel) {
        case TEST :
            INTERFACE_PRELAUNCH();
            erreur = INTERFACE_PRELAUNCH_TEST();
            INTERFACE_TEST_LECTURE_SD();
            DATA_LOGGER_W_PC();
            LO=1; 
            break;
        case COUNT :
            COUNTDOWN();                       
            break;
        case WAIT_SEPARATION :
            canlog = 1;
            TIMER_SEPARATION.start();
            break;
        case EJECTION :
            FCT_EJECTION();
            TIMER_SEPARATION.stop();
            TIMER_SEPARATION.reset();        
            break;
        case WAIT_PARACHUTE :
            TIMER_PARACHUTE.start();                     
            break;
        case PARACHUTE :
            FCT_PARACHUTE();        
            //Gestion du lachement du parachute
            break;
        case AUTO_PILOTE :
                        
            break;
        case LED :
            Affichage_Atterissage();
            break;  
        case ARRET :
            break;    
    }
}

//Gestion de l'interruption pour l'affichage et l'enregistrement des données
void INTERRUPTION(void){
     
    if (canlog)
    {
         leds = DATA_LOGGER_W_SD();
                #if FLIGHMODE
                DATA_LOGGER_W_PC();        
                #endif        
    } 
    
}  



    
    