#ifndef _ROAD_H_
#define _ROAD_H_

#include "AccCar.h"
#include "mbed.h"
#include "mqtt.h"

// no need to make it dynamic since we know our max upfront
#define MAX_CARS_ON_ROAD 5
#define MAC_CAR_BITS_ON_ROAD 1 << MAX_CAR_ON_ROAD

class AccCar;

class Road {
public:
    EventFlags go_flags;
    EventFlags done_flags;

    Road( int id , mqtt* mqtt_singleton);
    
    void add_acc_car(AccCar* car);
    
    void let_cars_update();
    
    void wait_for_car_update();
    
    bool can_car_enter(int speed);
    
    int get_new_car_id();
    
    int get_active_cars();
    
    AccCar* get_car(int id);
    
    AccCar* get_forward_car(int id);
    
    void DESTROY_ALL_CARS();
    
    bool simulating();
    
    int get_road_id();
    
    int get_road_clock();
        
    AccCar* get_last_car();
    
    int synchronize(int simulating);
    
    void free_msg();
    
private: 
    // for sharing intersections
    int road_id;
    
    mqtt* singleton;
    
    // store our cars here we only need 5
    AccCar* car_table[MAX_CARS_ON_ROAD];
    
    // how many active cars we have 
    int active_cars;
    
    // each car gets its own bit 
    int active_car_bits;
    
    //
    int road_clock;
    
    //
    road_msg_t* msg;
};
#endif
