/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include <cctype>
#include "Car.h"
#include "AccCar.h"
#include "TextLCD.h"
#include "Road.h"

Serial pc(USBTX, USBRX);
TextLCD lcd(p15, p16, p17, p18, p19, p20);

#define ROADLENGTH 100

// Read the max number of services to perform from pc input
int read_int(char* prompt) {
    int maxService = 0;
    
    pc.printf(prompt);
    
    char input;
    while(1) {
        input = pc.getc();
        pc.putc(input);
        
        if( std::isdigit(input) ) {
            maxService = (maxService * 10) + (input-'0');   
        } else {
            pc.putc(input);
            break;   
        } 
    }
    
    return maxService;
}

// main() runs in its own thread in the OS
int main()
{   
    // ------------------------------------------------------------------------------
    // The following three variables are used for timing statistics, do not modify them
    Timer stopwatch;    // A timer to keep track of how long the updates take, for statistics purposes
    int numberCycles = 0;
    int totalUpdateTime = 0;
    // ------------------------------------------------------------------------------
    
    Road road;    
    AccCar car1(1, &road, 0x01);
//    AccCar car2(2, &road, 0x02);
//    AccCar car3(3, &road, 0x03);
//    AccCar car4(4, &road, 0x04);
//    AccCar car5(5, &road, 0x05);
    
    road.add_acc_car(&car1);
    
    
    stopwatch.start();
    
//    car2.set_forward_car(&car1);
//    car3.set_forward_car(&car2);
//    car4.set_forward_car(&car3);
//    car5.set_forward_car(&car4);
    
    car1.reset();
//    car2.reset();
//    car3.reset();
//    car4.reset();
//    car5.reset();
    
    int timerForCar2 = rand() % 3 + 1;
    int timerForCar3 = rand() % 3 + 1;
    int timerForCar4 = rand() % 3 + 1;
    int timerForCar5 = rand() % 3 + 1;

    stopwatch.reset();
    
    do {
        
        road.let_cars_update();
        road.wait_for_car_update();
        // ------------------------------------------------------------------
        // Timing statistics logic, do not modify
        totalUpdateTime += stopwatch.read_ms();
        numberCycles++;
        stopwatch.reset();
        // ------------------------------------------------------------------
       // if (numberCycles == timerForCar2){
//            road.add_acc_car(&car2);
//        }
//        if (numberCycles == (timerForCar2+timerForCar3)){
//            road.add_acc_car(&car3);
//        }
//        if (numberCycles == (timerForCar2+timerForCar3+timerForCar4)){
//            road.add_acc_car(&car4);
//        }
        lcd.cls();
        pc.printf("1 %d -> %d\n", car1.position, car1.speed);
        //pc.printf("1 %d -> %d\n2 %d -> %d\n3 %d -> %d\n4 %d -> %d\n5 %d -> %d", car1.position, car1.speed, car2.position, car2.speed, car3.position, car3.speed, car4.position, car4.speed, car5.position, car5.speed);
        lcd.printf("1 %d -> %d\n", car1.position, car1.speed);
        
    } while (car1.position <= ROADLENGTH); 
    car1.stop();
//    car2.stop();
//    car3.stop();
//    car4.stop();
//    car5.stop();
    
            // ----------------------------------------------------------------------
    // Timing statistics printout, do not modify
    pc.printf("Average update cycle took: %fms \r\n", (totalUpdateTime*1.0)/(numberCycles*1.0));
    totalUpdateTime = 0;
    numberCycles = 0;
    // ----------------------------------------------------------------------
}
