#include "mbed.h"

//WATHDOG ENABLED IN OUR KL25Z_SystemInit.c (overloading library function SystemInit.c)
// It happens in this uC after reset watchdog is enabled with timeout=1024ms (2^10*LPO=1KHz)
//  so mbed developers to allow a learning use of this board disable it on SystemInit.c
// **BUT** SIM_COPC register can only be written once after reset and so it can not be enabled later
//  I think best solution is to overload SystemInit() using:   void $Sub$$SystemInit (void) {
//  original SystemInit() does not appear in export, it must be dowloaded from:
// https://developer.mbed.org/users/mbed_official/code/mbed-src/file/a11c0372f0ba/targets/cmsis/TARGET_Freescale/TARGET_KLXX/TARGET_KL25Z/system_MKL25Z4.c
//  you can arrive there from:
// https://developer.mbed.org/handbook/mbed-SDK and https://developer.mbed.org/users/mbed_official/code/mbed-src/
//
// MORE on this on: https://developer.mbed.org/users/chris/notebook/Patching-functions-and-libraries/
// and searching "ARM Compiler toolchain Using the Linker" "Using $Super$$ and $Sub$$ to patch symbol definitions"

// Kick (feed, reload) our watchdog timer
void wdt_kick(){
    SIM->SRVCOP = (uint32_t)0x55u;
    SIM->SRVCOP = (uint32_t)0xAAu;
}

// That set RED LED ON, do that first to evaluate boot time of peripherals
#define LIGHT 0
#define DARK 1
DigitalOut led_red(LED_RED, LIGHT);
DigitalOut led_green(LED_GREEN, DARK);
DigitalOut led_blue(LED_BLUE, DARK);

//Virtual serial port over USB using inboard second USB connector (USBKL25Z port)
#include "USBSerial.h"
//USBSerial pc;
//...( vendor_id, product_id, product_release, connect_blocking )
USBSerial pc( 0x1f00, 0x2012, 0x0001, false );
//REMEMBER TO USE: class USBSerial -> connect_blocking = false (default is true)
//  to avoid block of program when no USB cable connected in USBKL25Z port
//NOTE: USBSerial still blocks program when closing serial terminal, that is fixed by our watchdog


int main(void) {
    //to evaluate boot time I set led RED ON at the beginning of our main.cpp. TODO?: do it in SystemInit?
    led_blue = DARK;
    led_green = DARK;
    led_red = DARK;
    while(1)
    {
        led_blue = LIGHT;
        pc.printf("I am a virtual serial port\r\n");    // THAT COULD BLOCK
        wdt_kick();
        led_blue = DARK;
        wait(0.5);
    }
}