#include "EthernetInterface.h"
#include "Thread.h"
#include "mbed.h"

void led2ThreadProc(const void *param)
{
    // Toggle LED2
    DigitalOut led2(LED2, 1);
    for (;;)
    {
        led2 = !led2;
        Thread::wait(1000);
    }
}

void led3ThreadProc(const void *param)
{
    // Toggle LED3
    DigitalOut led3(LED3, 1);
    for (;;)
    {
        led3 = !led3;
        Thread::wait(2000);
    }
}

int main(void)
{
    // Start LED toggle(s)
    Thread led2(led2ThreadProc);
    Thread led3(led3ThreadProc);

    // Start the network
    EthernetInterface::init("192.168.5.100", "255.255.255.0", "0.0.0.0");
    EthernetInterface::connect();

    // Construct the server
    TCPSocketServer svr;
    svr.bind(1234);
    svr.listen();

    TCPSocketConnection conn;
    for (;;)
    {
        // Accept the next connection
        svr.accept(conn);
            
        // Manage the connection
        for (;;)
        {
            // Read the input
            char buf[32];
            int nr = conn.receive(buf, 32);
            if (nr <= 0)
            {
                break;
            }
            
            // Write the response twice
            conn.send(buf, nr);
            conn.send(buf, nr);
        }
    }
}
