#include "EthernetInterface.h"
#include "Thread.h"
#include "mbed.h"


int main(void)
{
    // Create a digital output on LED1
    DigitalOut led1(LED1);
    
    // Construct the Ethernet interface
    EthernetInterface eth;
    eth.init("192.168.5.100", "255.255.255.0", "0.0.0.0");
    eth.connect();

    // Construct the server
    TCPSocketServer svr;
    svr.bind(1234);
    svr.listen();
    for (;;)
    {
        // Accept the next connection
        TCPSocketConnection conn;
        if (svr.accept(conn) == 0)
        {
            // Turn the TCP_NODELAY option on
            int opt = 1;
            conn.set_option(IPPROTO_TCP, TCP_NODELAY, &opt, sizeof(opt));
            
            // Manage the connection
            for (;;)
            {
                // Read the input
                char buf[128];
                int nr = conn.receive(buf, 128);
                if (nr <= 0)
                {
                    break;
                }
                
                // Toggle the output on led1
                led1 = !led1;
                
                // Write the response twice
                conn.send(buf, nr);
                conn.send(buf, nr);
            }
        }
    }    
}