#include "EthernetInterface.h"
#include "Thread.h"
#include "mbed.h"

Serial pc(USBTX, USBRX);

void led2ThreadProc(const void *param)
{
    // Toggle LED2
    DigitalOut led2(LED2, 1);
    for (;;)
    {
        led2 = !led2;
        Thread::wait(1000);
    }
}

void led3ThreadProc(const void *param)
{
    // Toggle LED3
    DigitalOut led3(LED3, 1);
    for (;;)
    {
        led3 = !led3;
        Thread::wait(2000);
    }
}

int main(void)
{
    int nr;
    
    // Start LED2 toggle
    pc.printf("Starting LED 2 thread\r\n");
    Thread led2(led2ThreadProc);
    osDelay(1000);
    
    // Start LED3 toggle
    pc.printf("Starting LED 3 thread\r\n");
    Thread led3(led3ThreadProc);
    osDelay(1000);

    // Initialize the network
    pc.printf("Initializing network\r\n");
    nr = EthernetInterface::init("192.168.100.5", "255.255.255.0", "0.0.0.0");
    pc.printf(" Network Init: %d\r\n", nr);
    
    // Connect to the network
    pc.printf("Connecting to the network\r\n");
    nr = EthernetInterface::connect();
    pc.printf(" Connected: %d\r\n", nr);

    // Construct the server
    TCPSocketServer svr;
    svr.bind(1234);
    svr.listen();

    for (;;)
    {
        // Accept the next connection
        TCPSocketConnection conn;
        svr.accept(conn);
            
        // Manage the connection
        for (;;)
        {
            // Read the input
            char buf[32];
            int nr = conn.receive(buf, 32);
            if (nr <= 0)
            {
                break;
            }
            
            // Write the response twice
            conn.send(buf, nr);
            conn.send(buf, nr);
        }
    }
}
