#include "mbed.h"

double Kp = 7.5;
double Ki = 1.02;
double Kd = 10;
double samplingfreq = 1000;

double PID_controller(double error)
{
    //Kp = potmeter2.read()*3;
    
    double u_k = Kp * error;
    
    static double error_integral = 0;
    static double error_prev = error; // initialization with this value only done once!
    static BiQuad LowPassFilter(0.0640, 0.1279, 0.0640, -1.1683, 0.4241);
    
    error_integral = error_integral + error * 1/samplingfreq;
    double u_i = Ki * error_integral;
    
    double error_derivative = (error - error_prev)*samplingfreq;
    double filtered_error_derivative = LowPassFilter.step(error_derivative);
    double u_d = Kd * filtered_error_derivative;
    error_prev = error;
    return u_k+u_i+u_d;
}