#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"

//Define objects
HIDScope scope(2); // We’re going to send 2 channels of data
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker emgSampleTicker;

// filter chains for high pass, low pass and notch filters
BiQuadChain bqc;
BiQuad bqlow( 0.0128, 0.0256, 0.0128, -1.6556, 0.7068);
BiQuad bqhigh( 0.6458, -1.2917, 0.6458, -1.1620, 0.4213);
BiQuad bqnotch( 0.5, 0, 0.5, 0, 0);
volatile double y[50]= { };
volatile int n = 0;
volatile bool full = 0;

void emgSample() {
    double emgRaw = emg0.read();
    scope.set(0,emgRaw);
    
    double emgFiltered = bqc.step( emgRaw );
    scope.set(1,emgFiltered);
    
    // moving average and rectifier
    y[n] = abs(emgFiltered - 0.45);
    double emgavg = 0;
    if(full == 0){
        for(int i=0;i<50;i++){
            emgavg = emgavg + y[i];
        }
        emgavg = emgavg/(n+1);
    }
    else{
        for(int i=0;i<50;i++){
            emgavg = emgavg + y[i];
        }
        emgavg = emgavg/50;    
    }
    n++;        
    if(n == 50){
        n = 0;
        full = 1;
    }
    scope.set(2,emgavg);
    scope.send();
    // do stuff with filtered point emgavg
}


int main()
{   
    bqc.add( &bqlow ).add( &bqhigh ).add( &bqnotch );
    emgSampleTicker.attach( &emgSample, 0.01 );
    
    /*empty loop, sample() is executed periodically*/
    while(1) {}
}