#include "mbed.h"
#include "MODSERIAL.h"

Ticker potmeterticker;
InterruptIn button1(D2);
InterruptIn button2(D3);
AnalogIn potmeter(A0);
DigitalOut led(D4);
MODSERIAL pc(USBTX, USBRX);
volatile float pwmvalue;
volatile int pwm_pct = 50;
volatile int on_time_us=5000; //The time the LED should be on, in microseconds
volatile int off_time_us=5000;


void Increasebright()
{
    int frequency_Hz = 10000; 
    if (pwm_pct <= 95){ 
        pwm_pct = pwm_pct + 5;
    }
    on_time_us = (int) ((pwm_pct/100.0) * (1.0/frequency_Hz) * 1.0e8);
    off_time_us = (int) (( (100.0-pwm_pct)/100.0) * (1.0/frequency_Hz) * 1.0e8);
}


void Decreasebright()
{
    int frequency_Hz = 10000;
    if (pwm_pct >= 5){ 
        pwm_pct = pwm_pct - 5;
    }
    on_time_us = (int) ((pwm_pct/100.0) * (1.0/frequency_Hz) * 1.0e8);
    off_time_us = (int) (( (100.0-pwm_pct)/100.0) * (1.0/frequency_Hz) * 1.0e8);
}

int main()
{
    pc.baud(115200);
    pc.printf("Hello World!\r\n");
    
    button1.fall(&Increasebright);
    button2.fall(&Decreasebright);
    
    int n = 0;
    
    while (true) {
        led = 1;
        wait_us(on_time_us);
        led = 0; // Turn led off
        wait_us(off_time_us);
        //ReadPotmeterValues();
        if (n % 100 == 0){
            pc.printf("%i\r\n",pwm_pct);       
        }
        n++;
    }
}