#include "mbed.h"
#include "ATParser.h"

DigitalOut boot(D2);
DigitalOut status(D4);
BufferedSerial _serial(D1, D0, 1024);
ATParser _parser(_serial);

int main() {
    // Enter into data transmission / AT command mode
    boot = 1;
    status = 1;
    
    // Set the default factory parameters
    int res = _parser.send("AT+FAT=ON")      // Enter into AT command mode
        && _parser.recv("+OK")
        && _parser.send("AT+FMODE=AT_NONE")  // Enter into AT command mode with WLAN, TCP and UDP closed
        && _parser.recv("+OK")
        && _parser.send("AT+FEVENT=OFF")     // Event notification off
        && _parser.recv("+OK")
        && _parser.send("AT+FBONJOUR=OFF")   // Bonjour off
        && _parser.recv("+OK")
        && _parser.send("AT+FWMODE=STA")     // Enter into STA mode
        && _parser.recv("+OK")
        && _parser.send("AT+SAVE")           // Save all the setting
        && _parser.recv("+OK")
        && _parser.send("AT+FACTORY")        // Reboot
        && _parser.recv("+OK");
    
    if (!res)
        printf("EMW3162 config failed!\n");
    else  
        printf("EMW3162 config success!\n");
    return 0;
}

