#include "mbed.h"
#include "USBSerial.h"
#include "max32625pico.h"

USBSerial pc;      //Serial Terminal, specific to pico board

double readPwrMonitor(I2C &i2cbus, int channel_no); //Function to read power values from MAX34417
void configPwrMonitor(I2C &i2cbus);                 //Function to configure the power monitor device MAX34417

#define I2C_SLAVE_WRITE_ADDRESS 0x20
#define I2C_SLAVE_READ_ADDRESS 0x21
#define REG_UPDATE     0x00
#define REG_CONTROL    0x01
#define REG_ACC_COUNT  0x02
#define REG_PWR_ACC1   0x03
#define REG_PWR_ACC2   0x04
#define REG_PWR_ACC3   0x05
#define REG_PWR_ACC4   0x06
#define REG_V_CH1      0x07
#define REG_V_CH2      0x08
#define REG_V_CH3      0x09
#define REG_V_CH4      0x0A
#define REG_DID        0x10
#define REG_BULK_UPDATE 0x11
#define REG_BULK_POWER_READOUT  0x06
#define senseresistor 10
#define REG_BULK_VOLTAGE_READOUT 0x07



int main()
{
    int channel_no;
    int device_id;
    char dev_id[2];
    char data_val[2]= {0x0F,0};
    int status,status1;
    //initialize the MAX32625PICO board for +3.3V logic levels
    MAX32625PICO pico(MAX32625PICO::IOH_3V3, MAX32625PICO::VIO_IOH, MAX32625PICO::VIO_IOH);
    
    //initialize RGB LED channels and turn them off
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    
    
    //initialize the I2C master interface
    I2C i2c(P1_6, P1_7);    //SDA, SCL

    
    //delcare variables to store the raw power readings and the converted power readings
    double power_raw;
    double power_W;
    double step1results, step2results, step3results,senseresistor1;
     
    status= i2c.write(I2C_SLAVE_WRITE_ADDRESS,data_val, 1, true);
    status1=i2c.read(I2C_SLAVE_READ_ADDRESS,dev_id, 1, false);
     
    if(dev_id[0] == 44)
    {
        pc.printf ("Device Found \n");
    }
    else
    {
        pc.printf ("Device not found");
    }
    //write the configuration register
    configPwrMonitor(i2c);
    
    //the while loop will read the power raw reading, convert to actual power data, and then
    //print the result to a serial terminal. It will then toggle each on-board LED
    //for 11ms for a total of 33ms. A new power value is available every 12.5ms.
      while (true) {
        //the readPwrMonitor() function returns a raw 56-bit power accumulator reading
        //if successful and a zero if unsuccessful
        for (channel_no=0; channel_no <4 ; channel_no ++)
        {
        power_raw = readPwrMonitor(i2c,channel_no);
        
        //print poweronly if valid data is received. 
        if(status1 == 0)
        {
            step1results=power_raw;
            step2results = (double)step1results / (double)(1073741824);
            senseresistor1 = 0.001 *senseresistor;
            step3results = step2results * ((.1 / senseresistor1) * 24);
            power_W = step3results;
            
            //print a floating point value with 4 decimal places
            pc.printf("\r\n Channel %d : Power (W)= %.4f ",channel_no, power_W);
            
        }
        else {
            pc.printf("\r\nPowerMonitor Read Error");
        }
        }
        
        //toggle LEDs one at a time for a total of 33ms
        bLED = LED_OFF;
        rLED = LED_ON;
        wait(0.11);
        rLED = LED_OFF;
        gLED = LED_ON;
        wait(0.11);
        gLED = LED_OFF;
        bLED = LED_ON;
        wait(0.11);
    }
}

void configPwrMonitor(I2C &i2cbus)
{
    //creates an array to store the values to be written to the configuration register
  
    char data[2] = {REG_CONTROL, 0xA0};
    
    //this built-in I2C write function from mbed sends the configuration data to the MAX34417
    i2cbus.write(I2C_SLAVE_WRITE_ADDRESS, data, 2, false);
}

double readPwrMonitor(I2C &i2cbus, int channel)
{
    long pwr_raw = 0;
    long PowerAccumulatorValue;
    char data[2]= {0, 0};
    char data1[4];
    char data2[8];
    int Accumulator_Counter;
    data[0] = REG_UPDATE;
    data[1] =0;
    
   
    //it returns a zero on success or non-zero if unsuccessful
    int rtn_val = i2cbus.write(I2C_SLAVE_WRITE_ADDRESS, data, 1, true);
    
    //proceeds to read power only if previous command was successful
    if(rtn_val == 0)
    {
        data[0]= REG_ACC_COUNT;
        data[1] = 0;
        
        rtn_val = i2cbus.write(I2C_SLAVE_WRITE_ADDRESS, data, 1, true);
        rtn_val = i2cbus.read(I2C_SLAVE_READ_ADDRESS, data1, 4, false);
        Accumulator_Counter= (int)((data1[1] << 16) + (data1[2] << 8) + data1[3]);
 
        {
        //this I2C command reads the power and stores it in the 'data' array.
        //it returns a zero on success or non-zero if unsuccessful
        if(channel == 0 )
        {
        data[0] = REG_PWR_ACC1;
        data[1] =0;
        }
        else if (channel == 1)
        {
        data[0] = REG_PWR_ACC2;
        data[1] =0;
        }
        else if (channel == 2)
        {
        data[0] = REG_PWR_ACC3;
        data[1] =0;
        }
        else if (channel == 3)
        {
        data[0] = REG_PWR_ACC4;
        data[1] =0;
        }
        rtn_val = i2cbus.write(I2C_SLAVE_WRITE_ADDRESS, data, 1, true);
        rtn_val = i2cbus.read(I2C_SLAVE_READ_ADDRESS, data2, 8, false);
        
        //proceeds to format raw power data only if previous command was successful
        if(rtn_val == 0)
        {
            
            pc.printf("Successful");
        }
        
        }
    PowerAccumulatorValue= (long)(
                                                               ((long)data2[1] << (8 * 6)) +
                                                               ((long)data2[2] << (8 * 5)) +
                                                               ((long)data2[3] << (8 * 4)) +
                                                               ((long)data2[4] << (8 * 3)) +
                                                               ((long)data2[5] << (8 * 2)) +
                                                               ((long)data2[6] << (8 * 1)) +
                                                               ((long)data2[7] << (8 * 0)));
   }                                                            
    //returns the power reading
    pwr_raw=  (double)PowerAccumulatorValue/ (double)Accumulator_Counter;
    
    return pwr_raw;
}
    