#include "mbed.h"
#include "TLC5940.h"
#include "SerLCDv25.h"
#include "RPG.h"

SPI spi (p5, NC, p7);//pin5 is sin/ nc/p7 is sclk
DigitalOut dcprg (p6);//see p10
DigitalOut xlat (p8);
DigitalOut blank (p9);
DigitalOut vprg (p10);//this might need to be swapped with dcprg cause pins may be backwards
 
SPI adcspi (NC, p12, p13);//adc
DigitalOut cs(p14);//chipselect
PwmOut gsclk (p21);//constantly gives clock to grey scale clock
Serial lcdspi(p28, NC);//do not need pin 27 
//Constructor(Channel A input pin, Channel B input pin, Pushbutton input pin)
RPG encoder1 (p27,p29,p30);//encoder top left 
RPG encoder2 (p26,p25,p24);//encoder middle right
//RPG encoder3 (p22,p23,p11);//Left connected to check batterylevels
AnalogIn vbatt(p20);//analog input span of 0 to check for battery levels
InterruptIn interpulsea(p22);
InterruptIn interpulseb(p23);
InterruptIn inter(p11);//pb interrupt

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


int ic_number = 3; //change depending on ics you have
unsigned short leds [48];//number of channels you will have 16*number of ics

BusOut mux(p15, p16, p17, p18);
//A0
//mux
//mux
//a3
DigitalOut muxenable(p19);
//EN
void startup(void);
void checkbattery(void);
void ledstartup(void);
void ledtest(void);




int main() //main start function =============================================================<<<<<<<<<<<<<<<<<<<<<<<<<
{

    startup();
    setup (spi, vprg, xlat, blank, dcprg, gsclk, ic_number);//setsup led
    ledstartup();//test all leds in sequence 0-15 in R then G then B 
    //padpush(15,0xf0,0x0f,0x01);
    led1 =0;
    led2 =0;
    led3 =0;
    led4 =0;
    inter.fall(&ledstartup);
    interpulsea.fall(&ledtest);
    interpulseb.fall(&ledtest);
    while(1) // MAIN LOOOP ====================================================================<<<<<<<<<<<<<<<<<<<
    {
      muxenable = 1;
      for (int m = 0; m <=0xf; m++)
      {
        mux = m;
        //if adc > something do something
      }
      padpush(0x0,0x10,0xff,0x01);
      led4=!led4;
      update_led (spi, xlat, blank, (unsigned short*)leds);
      
    

   // update_led (spi, xlat, blank, (unsigned short*)leds);

    }//endofwhile
}//endofmain










//LCD FUNCTIONS================================================================================

void clear(void) {//clear lcd display
    lcdspi.putc(0xFE);
    lcdspi.putc(0x01);
}
 

void move_cursor(int line, int pos) {//move to a certain part of the lcd
    int cp;
    cp = pos + (line * 64) +128;
    lcdspi.putc(0xFE);
    lcdspi.putc(cp);
}



//Allan's Functions ===================================================================
void startup(void)
{
    for (int a = 0; a<3;a++)
    {
        clear();
        move_cursor(0,0);
        lcdspi.printf("Initializing");
        wait(0.2);
        lcdspi.printf(".");
        wait(0.2);      
        lcdspi.printf(".");
        wait(0.2);
        lcdspi.printf(".");
        wait(0.2);
    }    
    checkbattery();//in initialize, check battery levels
}

void checkbattery(void)
{
    float batterylevel = vbatt*100;
    
    //Check Battery Levels
        led1 = (vbatt > 0.2) ? 1 : 0;
        led2 = (vbatt > 0.4) ? 1 : 0;
        led3 = (vbatt > 0.6) ? 1 : 0;
        led4 = (vbatt > 0.8) ? 1 : 0;
        if (vbatt< 0.2) {
            clear();
            move_cursor(0,0);
            lcdspi.printf("WARNING");
            move_cursor(1,0);
            lcdspi.printf("LOW BATTERY");
            wait(2);}
        else 
        {
            clear();
            move_cursor(0,0);
            lcdspi.printf("Battery Level");
            move_cursor(1,0);
            lcdspi.printf("      %.0f%%",batterylevel);}
            wait(2);
    
}
//CheckallLEDS on startup
void ledstartup(void)
{
    clear();
    move_cursor(0,0);
    lcdspi.printf("LED TEST");
    for (int t = 0; t<=48;t++) //will check all leds and colors R G B to ensure there are no shorts
    {
        clearall();
        leds[t] = 0xff;
        update_led (spi, xlat, blank, (unsigned short*)leds);
        wait(0.02);
        
    }
    clear();
}

void ledtest(void)
{
    
}


//TLC5940 Pushbutton Functions============================================
//Writes to 1 button and allows you to control 3 colours
//k = 0-15 indicates which button you want to select
//r g b = value between 0x0-0xff. 0xff = full brightness
void padpush (int k,int r,int g,int b)
{
    //k=0x1-0xfff    
    leds[k] = r;
    leds[k+16] = g;
    leds[k+32] = b;
}
//Turn all LEDS on pads off
void clearall(void)
{
    for (int i = 0; i<=(ic_number*16-1);i++)
    {
         leds [i] =0;
    }
}