#include "TLC5940.h"



void setup (SPI &driver, DigitalOut &vprg, DigitalOut &xlat, DigitalOut &blank, DigitalOut &dcprg, PwmOut &gsclk, int num_ics)
{
    xlat = 0;               // hold GS/DC data constant
    blank = 1;
    blank = 0;              // Blank (squelch) all outputs
    dcprg = 0;              // dcprg points DC data to DC register.
    vprg = 0;               // sets drivers to GS mode. Set to 1 to change to DC mode
    gsclk.period_us (10);    // set grayscale clock 
    gsclk = 0.5;            // turn on grayscale clock to 50% duty cycle at afore mentioned frequency
    
    if (num_ics <= 0)
    {
        num_ics = 1;
    }
    else
    {
        num_ics = num_ics;
    }
    
    
    driver.format (12,0);
    driver.frequency (10000000);
        
    for (int i = num_ics; i >=0; i--){
        driver.write (0x0);}
}


void update_led (SPI &driver, DigitalOut &xlat, DigitalOut &blank, unsigned short* LEDS)
{
    blank = 1;
    blank = 0;
    
    for (int i = (48 - 1); i >= 0; i--)
        {
            driver.write (*(LEDS + i));
        }

    xlat = 1;
    xlat = 0;
}


