#ifndef TRAPEZOIDCONTROL_H_
#define TRAPEZOIDCONTROL_H_

#include "mbed.h"
#include <stdio.h>

class TrapezoidControl {
    public:
        //いつもの１
        TrapezoidControl();
        //いつもの２
        TrapezoidControl(float maxAcceleration, //最大加速度
                         float maxVelocity);    //最大速度
        //いつもの３    
        TrapezoidControl(float maxAcceleration, //最大加速度
                         float maxVelocity,     //最大速度
                         float strVerocity,     //初期速度
                         float endVerocity,     //終点速度
                         float tarDistance);    //目標距離
        //最大加速度と最大速度の設定・変更
        void setParameter(float maxAcceleration, float maxVelocity);
        //目標値の設定・変更
        void setDis(float tarDistance, float endVerocity);
        //目標値の初期化
        void reset();
        //台形制御の開始
        void start();
        //速度の取得
        float getVel();
        //距離(理論値)の取得
        float getDis();
    private:
        float maxAcceleration_;
        float maxVelocity_;
        float strVerocity_;
        float endVerocity_;
        float tarDistance_;
        float time;
        Timer sampling;
};

#endif //TRAPEZOIDCONTROL_H_