#ifndef MOTOR_H_
#define MOTOR_H_

#include <stdint.h>

//#define USE_MOTOR0_SENSOR
namespace MOTOR
{
    #define FREE    0
    #define BACK    1
    #define FOR     2
    #define BRAKE   3

    #define MOUNTING_MOTOR_NUM 5

    #define MOTOR0_D1 directions[0]
    #define MOTOR0_D2 directions[1]
    #define MOTOR1_D1 directions[2]
    #define MOTOR1_D2 directions[3]
    #define MOTOR2_D1 directions[4]
    #define MOTOR2_D2 directions[5]
    #define MOTOR3_D1 directions[6]
    #define MOTOR3_D2 directions[7]
    #define MOTOR4_D1 directions[8]
    #define MOTOR4_D2 directions[9]

    #define MOTOR0_D1_PIN D3
    #define MOTOR0_D2_PIN A4
    #define MOTOR1_D1_PIN A5
    #define MOTOR1_D2_PIN D6
    #define MOTOR2_D1_PIN D8
    #define MOTOR2_D2_PIN D9
    #define MOTOR3_D1_PIN D12
    #define MOTOR3_D2_PIN A3
    #define MOTOR4_D1_PIN A1
    #define MOTOR4_D2_PIN A0

    #define MOTOR0_PWM_PIN D2
    #define MOTOR1_PWM_PIN D7
    #define MOTOR2_PWM_PIN D10
    #define MOTOR3_PWM_PIN D11
    #define MOTOR4_PWM_PIN A2
    
    #ifdef USE_MOTOR0_SENSOR
        #define MOTOR_START_NUM 1
    #else 
        #define MOTOR_START_NUM 0
    #endif

    typedef struct
    {
        union
        {
            struct
            {
                unsigned int d2 : 1;
                unsigned int d1 : 1;
                unsigned int : 6;
            };
            uint8_t dir;
        };
        float pwm;
    }MotorStatus;

    class Motor
    {
        public:
            static void Initialize(void);
            static void Update(MotorStatus *status);
            static void SetDefault(void);
            static int SetStatus(float pwm);
            static float SetPWM(float pwm);
    };
}

#endif
