#ifndef  MCP_H_
#define  MCP_H_

#include "mbed.h"
#include "MCP23017.h"

#define SDA PB_7
#define SCL PB_6

#define MCP_ADDRESS 0x40

#define GPA0 0
#define GPA1 1
#define GPA2 2
#define GPA3 3
#define GPA4 4
#define GPA5 5
#define GPA6 6
#define GPA7 7
#define GPB0 8
#define GPB1 9
#define GPB2 10
#define GPB3 11
#define GPB4 12
#define GPB5 13
#define GPB6 14
#define GPB7 15

typedef enum {
    OUTPUT,
    INPUT,
    INPUT_PULLUP,
}pin_mode;

typedef struct byte{
    uint8_t port_A;
    uint8_t port_B;
}byte;

typedef union {
    byte port;
    uint16_t all;
}mcp_data;

class MCP {
    public:
        /* MCP class constracter
        /   deffult Input
        /                                              */
        MCP(PinName sda, PinName scl, uint8_t device_address);
        // MCP pin define * pin number is 0 ~ 15
        void PinMode(uint8_t pin, pin_mode mode);
        // MCP DigitalWrite * pin number is 0 ~ 15
        void Write(uint8_t pin, bool signal);
        // MCP DigitalRead * pin number is 0 ~ 15
        bool Read(uint8_t pin);
        // MCP initialize
        void Initialize(void);
        // MCP register update and read new data
        void Update(void);
        
    private:
        I2C i2c;
        MCP23017 mcp;
        char _read_opcode;
        char _write_opcode;
        
        mcp_data _iodir_data;
        mcp_data _pull_data;
        mcp_data _read_data;
        mcp_data _write_data;
        
        void _Write(uint8_t address, uint8_t data);
        void _Read(uint8_t address, uint8_t data);
        
        void I2Crestart(void);
    
};

#endif //I2C_H_