#include "mbed.h"
#include "RingBuffer.h"
#include "SO1602A.h"
#include "setup.h"

// ---------- ピン設定 ---------- //
AnalogIn y1(Z0);
AnalogIn y2(Z1);
AnalogIn y3(Z2);

DigitalOut select1[]= {
    DigitalOut(SELECT1_0),
    DigitalOut(SELECT1_1),
    DigitalOut(SELECT1_2),
    DigitalOut(SELECT1_3),
};
DigitalOut select2[]= {
    DigitalOut(SELECT2_0),
    DigitalOut(SELECT2_1),
    DigitalOut(SELECT2_2),
    DigitalOut(SELECT2_3),
};
DigitalOut select3[]= {
    DigitalOut(SELECT3_0),
    DigitalOut(SELECT3_1),
    DigitalOut(SELECT3_2),
    DigitalOut(SELECT3_3),
};
DigitalOut uartSE(UART_SE);
DigitalOut LED(LED3);
//Serial uart(USBTX,USBRX);  // パソコン用
Serial uart(UARTTX,UARTRX);

I2C i2c(SDA,SCL);
SO1602A oled(i2c,0x78);

// ------------------------------- //

typedef union {
    struct {
        int s0 : 1;
        int s1 : 1;
        int s2 : 1;
        int s3 : 1;
        int : 4;
    };
    uint8_t all;
} MP_Channel;

#define  BUFFER_SIZE  10
char RS485Data[BUFFER_SIZE];
RINGBUFFER::RingBuffer RS485uart(RS485Data,BUFFER_SIZE);

static bool port_select[PORT_NUM] = {PORT_0,PORT_1,PORT_2,PORT_3,PORT_4,PORT_5,PORT_6,PORT_7};
                  
int read_data = 0;                               
char send_data[PORT_NUM] = {0};
bool ACflag = true;
bool NCflag = true;

void Transmit();
float SensorRead(int pin);
void SendDataUpdate(char send_data_[]);

int main() {
    
    uartSE = 1; //送信固定
    uart.baud(BORATE);
    uart.attach(Transmit,Serial::TxIrq);
    
    while(1) {
        for(int i = 0; i < PORT_NUM; i++) {
            if(port_select[i] == true) {  // ポートを使っていたら
                NCflag = true;
                ACflag = true;
                send_data[i] = 0;
                for(int j = 0; j < SENSOR_NUM; j++) {
                    read_data = SensorRead(sensor_number[i][j]);
                    send_data[i] += read_data * sensor_weight[j];
                    if(read_data) ACflag = false;
                    else NCflag = false;
                }
                if(ACflag) send_data[i] = AC_WEIGHT;
                else if(NCflag) send_data[i] = NC_WEIGHT;
            } else {
                send_data[i] = NO_PORT;
            }
        }
        SendDataUpdate(send_data);
    }
}

void Transmit() {
    __disable_irq();
    //uart.printf("%d\n\r",RS485uart.GetData());
    uart.putc(RS485uart.GetData());
    __enable_irq();
    
}

void SendDataUpdate(char send_data_[]) {
    __disable_irq();
    if(!RS485uart.InAnyData()) {
        RS485uart.PutData('S');
        for(int i = 0; i < PORT_NUM; i++) {
            RS485uart.PutData(send_data_[i]);
        }
        RS485uart.PutData('F');
    }
     __enable_irq();
}

float SensorRead(int pin) {
    MP_Channel ch;
    float read_data;
    if(pin < 16) {
        ch.all = pin;
        select1[0] = ch.s0;
        select1[1] = ch.s1;
        select1[2] = ch.s2;
        select1[3] = ch.s3;
        wait_us(1);
        read_data = y1.read();
    } else if(pin < 32) {
        ch.all = pin - 16;
        select2[0] = ch.s0;
        select2[1] = ch.s1;
        select2[2] = ch.s2;
        select2[3] = ch.s3;
        wait_us(1);
        read_data = y2.read();
    } else if(pin < 48) { 
        ch.all = pin - 32;
        select3[0] = ch.s0;
        select3[1] = ch.s1;
        select3[2] = ch.s2;
        select3[3] = ch.s3;
        wait_us(1);
        read_data = y3.read();
    } else {
        read_data = 1.0;
    }
    return (read_data < THRESHOLD) ? 1 : 0;
}


