#include "mbed.h"
#include "Process.h"

#include <stdlib.h>
#include "../../CommonLibraries/PID/PID.h"
#include "../../Communication/RS485/ActuatorHub/ActuatorHub.h"
#include "../../Communication/RS485/LineHub/LineHub.h"
#include "../../Communication/Controller/Controller.h"
#include "../../Switch/Switch.h"

#include "../../LED/LED.h"
#include "../../Safty/Safty.h"
#include "../Using.h"

using namespace SWITCH;
using namespace PID_SPACE;

using namespace LINEHUB;

static CONTROLLER::ControllerData *controller;
ACTUATORHUB::MOTOR::MotorStatus motor[MOUNTING_MOTOR_NUM];
ACTUATORHUB::SOLENOID::SolenoidStatus solenoid;

static bool lock;
static bool processChangeComp;
static int current;

static void AllActuatorReset();

#ifdef USE_SUBPROCESS
static void (*Process[USE_PROCESS_NUM])(void);
#endif

#pragma region USER-DEFINED_VARIABLES_AND_PROTOTYPE

/*Replace here with the definition code of your variables.*/


Serial pc(USBTX, USBRX);

uint8_t SetStatus(int);
uint8_t SetPWM(int);

#pragma endregion USER-DEFINED_VARIABLES_AND_PROTOTYPE

#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
static void Process0(void);
#endif
#if USE_PROCESS_NUM>1
static void Process1(void);
#endif
#if USE_PROCESS_NUM>2
static void Process2(void);
#endif
#if USE_PROCESS_NUM>3
static void Process3(void);
#endif
#if USE_PROCESS_NUM>4
static void Process4(void);
#endif
#if USE_PROCESS_NUM>5
static void Process5(void);
#endif
#if USE_PROCESS_NUM>6
static void Process6(void);
#endif
#if USE_PROCESS_NUM>7
static void Process7(void);
#endif
#if USE_PROCESS_NUM>8
static void Process8(void);
#endif
#if USE_PROCESS_NUM>9
static void Process9(void);
#endif
#endif

void SystemProcessInitialize()
{
    #pragma region USER-DEFINED_VARIABLE_INIT
    /*Replace here with the initialization code of your variables.*/

    #pragma endregion USER-DEFINED_VARIABLE_INIT

    lock = true;
    processChangeComp = true;
    current = DEFAULT_PROCESS;

#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
    Process[0] = Process0;
#endif
#if USE_PROCESS_NUM>1
    Process[1] = Process1;
#endif
#if USE_PROCESS_NUM>2
    Process[2] = Process2;
#endif
#if USE_PROCESS_NUM>3
    Process[3] = Process3;
#endif
#if USE_PROCESS_NUM>4
    Process[4] = Process4;
#endif
#if USE_PROCESS_NUM>5
    Process[5] = Process5;
#endif
#if USE_PROCESS_NUM>6
    Process[6] = Process6;
#endif
#if USE_PROCESS_NUM>7
    Process[7] = Process7;
#endif
#if USE_PROCESS_NUM>8
    Process[8] = Process8;
#endif
#if USE_PROCESS_NUM>9
    Process[9] = Process9;
#endif
#endif
}

static void SystemProcessUpdate()
{
#ifdef USE_SUBPROCESS
    if(controller->Button.HOME) lock = false;

    if(controller->Button.START && processChangeComp) {
        current++;
        if (USE_PROCESS_NUM < current) current = USE_PROCESS_NUM;
        processChangeComp = false;
    } else if(controller->Button.SELECT && processChangeComp) {
        current--;
        if (current < 0) current = 0;
        processChangeComp = false;
    } else if(!controller->Button.SELECT && !controller->Button.START) processChangeComp = true;
#endif

#ifdef USE_MOTOR
    ACTUATORHUB::MOTOR::Motor::Update(motor);
#endif

#ifdef USE_SOLENOID
    ACTUATORHUB::SOLENOID::Solenoid::Update(solenoid);
#endif

#ifdef USE_RS485
    ACTUATORHUB::ActuatorHub::Update();
    //LINEHUB::LineHub::Update();
#endif

}

void SystemProcess()
{
    SystemProcessInitialize();
    
    while(1) {
    	
    	
    	
    	

		#ifdef USE_MU
        controller = CONTROLLER::Controller::GetData();
		#endif

		#ifdef USE_ERRORCHECK
        if(SAFTY::ErrorCheck::Check() & SAFTY::Error::ControllerLost) {
            CONTROLLER::Controller::DataReset();
            AllActuatorReset();
            lock = true;
        } else
		#endif
        {

			#ifdef USE_SUBPROCESS
            if(!lock) {
                Process[current]();
            } else
			#endif
            {
                //ロック時の処理
            }
        }
        
        SystemProcessUpdate();
    }
}




#pragma region PROCESS
#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
static void Process0()
{
    AllActuatorReset();
}
#endif

#if USE_PROCESS_NUM>1
static void Process1()
{

}
#endif

#if USE_PROCESS_NUM>2
static void Process2()
{

}
#endif

#if USE_PROCESS_NUM>3
static void Process3()
{
    
}
#endif

#if USE_PROCESS_NUM>4
static void Process4()
{
    
}
#endif

#if USE_PROCESS_NUM>5
static void Process5()
{

}
#endif

#if USE_PROCESS_NUM>6
static void Process6()
{

}
#endif

#if USE_PROCESS_NUM>7
static void Process7()
{
   
}
#endif

#if USE_PROCESS_NUM>8
static void Process8()
{
	
}
#endif

#if USE_PROCESS_NUM>9
static void Process9()
{

}
#endif
#endif
#pragma endregion PROCESS

static void AllActuatorReset()
{
	#ifdef USE_SOLENOID
	    solenoid.all = ALL_SOLENOID_OFF;
	#endif
	
	#ifdef USE_MOTOR
	    for (uint8_t i = 0; i < MOUNTING_MOTOR_NUM; i++) {
	        motor[i].dir = FREE;
	        motor[i].pwm = 0;
	    }
	#endif
}

#pragma region USER-DEFINED-FUNCTIONS

uint8_t SetStatus(int pwmVal)
{
    if (pwmVal < 0) return BACK;
    else if (pwmVal > 0) return FOR;
    else if (pwmVal == 0) return BRAKE;
    else return BRAKE;
}

uint8_t SetPWM(int pwmVal)
{
    if (pwmVal == 0 || pwmVal >  255 || pwmVal < -255) return 255;
    else return abs(pwmVal);
}

#pragma endregion
