#include "USS.h"
#include "mbed.h"

USS::USS(PinName echoPin, PinName trigPin, PinName tempPin) 
                        :echo_(echoPin), trig_(trigPin), temp_(tempPin)  
{
    distance_ = 0;
    
}

double USS::ReadDis(void) {
    int temp = temp_.getTemperature();
    double duration = echo_.read_high_us(5000);
    trig_.write_us(1,10);
    if(duration > 0){
        duration /= 2;
        double sspead = 331.5+0.6*temp;
        distance_ = duration*sspead*100/1000000;
    } else distance_ = 0;
    return distance_;
}

double USS::GetDis(void) {
    return distance_;
}