#ifndef SWITCH_H_
#define SWITCH_H_

#include "mbed.h"
#include <stdint.h>

namespace SWITCH {
    #define SW_ON   0
    #define SW_OFF  1

    //DipSwitch
    #define DIP0_PIN    PA_4
    #define DIP1_PIN    PA_6
    #define DIP2_PIN    PA_7
    #define DIP3_PIN    PC_7
                        

    //Multiplexer
    #define LS_PIN      PD_2
    #define SELECT0_PIN PC_12
    #define SELECT1_PIN PA_15
    #define SELECT2_PIN PC_13
    #define SELECT3_PIN PB_7
    
    
    #define DIP0    dipSw[0]
    #define DIP1    dipSw[1]
    #define DIP2    dipSw[2]
    #define DIP3    dipSw[3]
    
    //Normal
    #define LS_16  PB_6
    #define LS_17  PB_9
    #define LS_18  PB_8
    #define LS_19  PC_9
    #define LS_20  PC_8

    class DipSw {
        public:
        static void Initialize();
        static uint8_t GetStatus();
    };
    
    class LimitSw {
        public:
        static void Initialize();
        static bool IsPressed(int index);
    };

    typedef union {
        struct {
            int s0 : 1;
            int s1 : 1;
            int s2 : 1;
            int s3 : 1;
            int : 4;
        };
        uint8_t all;
    } MP_Channel;
}

#endif
