#include "mbed.h"
#include "DHT.h"
#include"Air_Quality.h"

AirQuality airqualitysensor;
int current_quality = -1;
PinName analogPin = A0;

DHT sensor(D4, DHT11);
InterruptIn motion(D3);
AnalogIn luminance(A1);

DigitalOut led_R(LED_RED);
DigitalOut led_G(LED_GREEN);
DigitalOut led_B(LED_BLUE);

int motion_detected = 0;

// Interrupt Handler
void AirQualityInterrupt()
{
    AnalogIn sensor(analogPin);
    airqualitysensor.last_vol = airqualitysensor.first_vol;
    airqualitysensor.first_vol = sensor.read()*1000;
    airqualitysensor.timer_index = 1;
}

void irq_handler(void)
{
    motion_detected = 1;
}

int main()
{
    int error = 0;
    float hum = 0.0f;
    float cel = 0.0f;
    
    airqualitysensor.init(analogPin, AirQualityInterrupt);
    
    motion.rise(&irq_handler);
    
    while(1)
    {
        wait(0.3);
        error = sensor.readData();
        
        if (0 == error) {
            hum = sensor.ReadHumidity();
            cel = sensor.ReadTemperature(CELCIUS);
            printf("1. Humidity : %4.2f\r\n\n", hum);
            wait(0.3);
            printf("2. Temperature in Celcius : %2.2f\r\n\n", cel);
            wait(0.3);
        }
        else {
            //printf("Error : %d\n", error);
        }
        
        if(motion_detected) {
            motion_detected = 0;

            printf("3. Something move!\r\n\n");
            wait(0.3); 
        }
        
        if(luminance.read()){
            
            if(0.1<=luminance.read()&&luminance.read()<=0.3){
                led_R=0; led_G=0; led_B=1;}   // yellow LED on
                
            else{
                led_R=1; led_G=1; led_B=1;}   // led off
             
            printf("4. Luminance: %f\r\n\n", luminance.read());    
            wait(0.3);
        }
        else {
            led_R=0; led_G=0; led_B=0;    // white LED on 
            printf("4. Luminance: %f\r\n\n", luminance.read());
            wait(0.3);         
        }
        //air quality sensor
        current_quality=airqualitysensor.slope();
        if (current_quality >= 0) { // if a valid data returned.
            if (current_quality == 0)
                printf("  High pollution! Force signal active\n\r\n");
            else if (current_quality == 1)
                printf("  High pollution!\n\r\n");
            else if (current_quality == 2)
                printf("  Low pollution!\n\n\r");
            else if (current_quality == 3)
                printf("  Fresh air!\n\r\n");
        }
    }
}
