#include "mbed.h"
#include "EthernetInterface.h"
#include "FsHandler.h"
#include "HTTPServer.h"
#include "SDFileSystem.h"

#include "DHT.h"
#include "Servo.h"

int motion_detected = 0;   // motion
int i=0;  // touch

extern int lumi_val;
extern int cel_val;
extern int touch_val;
extern int control;

DHT sensor(D8, DHT11);
InterruptIn motion(D9);
AnalogIn luminance(A1);
InterruptIn event(D10);  // touch
Servo myservo(D14);  // touch servo 

DigitalOut led_R(LED1);
DigitalOut led_G(LED2);
DigitalOut led_B(LED3);

DigitalOut vol_in(A5);

#ifdef TARGET_WIZWIKI_W7500
    //Choose one of file system.
    SDFileSystem local(SD_MOSI, SD_MISO, SD_CLK, SD_SEL, "local");//PB_3, PB_2, PB_1, PB_0
    //LocalFileSystem local("local");
#endif
 
#ifdef TARGET_WIZWIKI_W7500
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};
#endif
 
EthernetInterface eth;
HTTPServer  svr;
char ip_addr[] = "192.168.1.111";
char subnet_mask[] = "255.255.255.0";
char gateway_addr[] = "192.168.1.1";
 
//#define DHCP //If uncomment, W7500 runs DHCP
 
 
// motion
void irq_handler()   
{
    motion_detected = 1;
}

// touch
void trigger() { 
    
    if(touch_val == 0)
        printf("5. Touch : Can't move!\r\n\r\n");
    else {
        printf("5. Touch : move!\r\n\r\n"); 
        if(i==0)
        myservo = 0;
        else if (i==1)
        myservo = 0.3;
        else if (i==2)
        myservo = 0.6;
        else if (i==3)
        myservo = 0.9;
    }
  
    if (i<3)
    i++;
    else
    i=0;
}

void sensor_5() {
        
        int rd_sensor = 0;  // when rd_sensor = 0, sensor is ready to read the data.
        float hum = 0.0f;
        float cel = 0.0f;
        vol_in = 0;
    
        //DHT sensor
        rd_sensor = sensor.readData();
        if (0 == rd_sensor) {
            hum = sensor.ReadHumidity();
            cel = sensor.ReadTemperature(CELCIUS);
            
            printf("1. Humidity : %4.2f\r\n\n", hum);
            wait(0.3);
            printf("2. Temperature in Celcius : %2.2f\r\n\n", cel);
            wait(0.3); }
        else
            printf("1,2. Error! : %d\r\n\n", rd_sensor);
        
        // motion    
        if(motion_detected) {
            motion_detected = 0;

            printf("3. Something move!\r\n\r\n");
            wait(0.3);
            }
        
        // luminance    
        printf("4. Luminance: %f\r\n\r\n", luminance.read());
        //printf(" + lumi_val = %d\r\n\r\n", lumi_val);
        
        if(lumi_val == 0) {
            led_R=1; led_G=1; led_B=1;} // led off
        
        else {     
            if(luminance.read()<=0.1){
                led_R=0; led_G=0; led_B=0;} // white LED on
        
            else if(0.1<=luminance.read()&&luminance.read()<=0.3){
                led_R=0; led_G=0; led_B=1;} // yellow LED on
            
            else{
                led_R=1; led_G=1; led_B=1;} // led off
        }
        
        if(control == 1) {
            if(cel_val == 0)
                vol_in = 0;
            else if(cel_val == 1)
                vol_in = 1; }
        else {
            if(cel < 34)
                vol_in = 0;
            else if(cel >= 34)
                vol_in = 1; }
            

        wait(1);
}

 
 
int main()
{    /*
    int rd_sensor = 0;  // when rd_sensor = 0, sensor is ready to read the data.
    float hum = 0.0f;
    float cel = 0.0f;  */
     
    HTTPFsRequestHandler::mount("/local/", "/");
    svr.addHandler<HTTPFsRequestHandler>("/");
 
#ifdef TARGET_WIZWIKI_W7500
    
    #ifdef DHCP
        eth.init(mac_addr); //Use DHCP
    #else
        eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif
 
#else
 
    #ifdef DHCP
        eth.init(); //Use DHCP
    #else
        eth.init(ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif
 
#endif
 
    printf("Check Ethernet Link\r\n");
    while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }
    printf("Link up\r\n");
 
    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());
 
    if (!svr.start(80, &eth)) {
 
        error("Server not starting !");
        exit(0);
    }
 
    motion.rise(&irq_handler);
    event.rise(&trigger);  // touch
    
    while(1) {
        svr.poll();
        sensor_5();
        
        if(control == 0) {
            while (1)
                sensor_5();
        }
        wait(1);
        
    
        /*
        //DHT sensor
        rd_sensor = sensor.readData();
        if (0 == rd_sensor) {
            hum = sensor.ReadHumidity();
            cel = sensor.ReadTemperature(CELCIUS);
            cel = cel*cel_val; // control with html
            printf("1. Humidity : %4.2f\r\n\n", hum);
            wait(0.3);
            printf("2. Temperature in Celcius : %2.2f\r\n\n", cel);
            wait(0.3);
        }
        else
            printf("1,2. Error! : %d\r\n\n", rd_sensor);
        
        // motion    
        if(motion_detected) {
            motion_detected = 0;

            printf("3. Something move!\r\n\r\n");
            wait(0.3);
            }
        
        // luminance    
        printf("4. Luminance: %f\r\n\r\n", luminance.read());
        //printf(" + lumi_val = %d\r\n\r\n", lumi_val);
        
        if(lumi_val == 0) {
            led_R=1; led_G=1; led_B=1;} // led off
        
        else {     
            if(luminance.read()<=0.1){
                led_R=0; led_G=0; led_B=0;} // white LED on
        
            else if(0.1<=luminance.read()&&luminance.read()<=0.3){
                led_R=0; led_G=0; led_B=1;} // yellow LED on
            
            else{
                led_R=1; led_G=1; led_B=1;} // led off
        }  */ 
        //wait(1);
    }
}