#include "Image.h"

/*
The idea behind  Image:

    level_1_x, level_1_y : Coordinates for gold/rock in level 1/level 2/level 3. Random coordinates will mess up with the difficulty of game.
    level_2_x, level_2_y
    level_3_x, level_3_y

    They are global variables stored in "Global_my"

*/


// this a private function used to draw map for level 1
void Image::draw_map_1(N5110 &lcd)
{
    int i;
    for(i=0; i<3; i=i+1) {//0-3 are BigGold in level 1
        lcd.drawSprite(level_1_x[i],level_1_y[i], 5, 8, (int*)BigGold);
    };
    for(i=3; i<5; i=i+1) {//0-3 are SmallGold in level 1
        lcd.drawSprite(level_1_x[i], level_1_y[i], 4, 3, (int*)SmallGold);
    };
    for(i=5; i<7; i=i+1) {//0-3 are BigRock in level 1
        lcd.drawSprite(level_1_x[i], level_1_y[i], 8, 10, (int*)BigRock);
    }
    lcd.printString("Goal:40",40,5);
}

// this a private function used to draw map for level 2
// same idea as level 1 with different coordinates and goal
void Image::draw_map_2(N5110 &lcd)
{
    int i;
    //big gold
    for(i=0; i<4; i=i+1) {
        lcd.drawSprite(level_2_x[i],level_2_y[i], 5, 8, (int*)BigGold);
    };
    // small gold
    for(i=4; i<7; i=i+1) {
        lcd.drawSprite(level_2_x[i], level_2_y[i], 4, 3, (int*)SmallGold);
    };
    //Big rock
    for(i=7; i<10; i=i+1) {
        lcd.drawSprite(level_2_x[i], level_2_y[i], 8, 10, (int*)BigRock);
    }
    lcd.printString("Goal:95",40,5);// printing the goal we need to pass level 1
}

// this a private function used to draw map for level 3
// same idea as level 1 with different coordinates and goal
void Image::draw_map_3(N5110 &lcd)
{
    int i;
    //big gold
    for(i=0; i<5; i=i+1) {
        lcd.drawSprite(level_3_x[i],level_3_y[i], 5, 8, (int*)BigGold);
    };
    // small gold
    for(i=5; i<8; i=i+1) {
        lcd.drawSprite(level_3_x[i], level_3_y[i], 4, 3, (int*)SmallGold);
    };
    //Big rock
    for(i=8; i<12; i=i+1) {
        lcd.drawSprite(level_3_x[i], level_3_y[i], 8, 10, (int*)BigRock);
    }
    lcd.printString("Goal:150",34,5);
}

//This function draw every thing on the map.
void Image::draw_object(int x, int y, const int *graph, N5110 &lcd, Image &Image, float time, Rotate &Rotate, float angle, float speed, int sizex, int sizey)
{
    x =  x - speed*cos(angle);//This can calculate the route when we rotate, release or pull. 
    y =  y + speed*sin(angle);
    lcd.clear();
    lcd.drawSprite(x, y, sizex,sizey, (int*) graph);//draw hook/Gold/Rock depends on what stage you are at.
    lcd.drawLine(42,0, x, y, 1);//draw line between (42,0) and hook/Gold/Rock.
    Image.draw_map_1(lcd);//draw map
    Image.print_UI(lcd);//draw UI
    lcd.refresh();
    wait(time);
    Rotate.hookpoint[0]=x;//return the new hook point, we cannot replace x,y in the declaration with hookpoint because the rotate stage.
    Rotate.hookpoint[1]=y;
}

// same idea as level 1 with different map
void Image::draw_object_2(int x, int y, const int *graph, N5110 &lcd, Image &Image, float time, Rotate &Rotate, float angle, float speed,  int sizex, int sizey)
{
    x =  x - speed*cos(angle);
    y =  y + speed*sin(angle);
    //Score = Score + new_score;
    lcd.clear();
    lcd.drawSprite(x, y, sizex,sizey, (int*) graph);
    lcd.drawLine(42,0, x, y, 1);
    Image.draw_map_2(lcd);
    Image.print_UI(lcd);
    lcd.refresh();
    wait(time);
    Rotate.hookpoint[0]=x;
    Rotate.hookpoint[1]=y;
}

// same idea as level 1 with different map
void Image::draw_object_3(int x, int y, const int *graph, N5110 &lcd, Image &Image, float time, Rotate &Rotate, float angle, float speed,  int sizex, int sizey)
{
    x =  x - speed*cos(angle);
    y =  y + speed*sin(angle);
    //Score = Score + new_score;
    lcd.clear();
    lcd.drawSprite(x, y, sizex,sizey, (int*) graph);
    lcd.drawLine(42,0, x, y, 1);
    Image.draw_map_3(lcd);
    Image.print_UI(lcd);
    lcd.refresh();
    wait(time);
    Rotate.hookpoint[0]=x;
    Rotate.hookpoint[1]=y;
}

//This function can print UI which includes Score, Goal, Time remain, TNT number.
void Image::print_UI(N5110 &lcd)
{
    lcd.drawSprite(0, 40,6,6, (int*)TNT_graph);
    char buffer[14];
    char buffer2[14];
    char buffer3[14];
    sprintf(buffer,"%i",Score);
    sprintf(buffer2,"%i",Timer_1);
    sprintf(buffer3,":%i",TNT_num);
    lcd.printString(buffer,0,0);
    lcd.printString(buffer2,70,0);
    lcd.printString(buffer3,8,5);
}