#include "mbed.h"
#include "BtnEventM0.h"

//        LSB                                          MSB
//        2^0   2^1   2^2                              2^9
BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
//        D18  D17  D16  D15  D14  D13  D4   D3   D2   D1

// Hier wird der momentane Zustand der Fahrradleuchte als
// Binärzahl dargestellt
BusOut stLED(P1_13,P1_12);

BtnEventM0 Btn1(P1_16), Btn2(P0_23);

class FahrradLeuchte {
    public:
        void Init() { state=1; t1.start(); }
        void State1Func();
        void State2Func();
        void State3Func();
    public:
        void State1Action();
        void State2Action();
        void State3Action();
    public:
        // State sagt uns in welchem Zustand sich die Fahrradleuchte gerade befindet
        int state;
        Timer t1;
};

// ein Objekt der Klasse FahrradLeuchte anlegen
FahrradLeuchte fl;

int main()
{
    Btn1.Init(); Btn2.Init();
    fl.Init();
    
    while(1)
    {
        if( fl.state==1)
          fl.State1Func();
        if( fl.state==2)
          fl.State2Func();
        if( fl.state==3)
          fl.State3Func();
    }
}

void FahrradLeuchte::State1Func()
{
    // Einmalige Aktion beim Eintritt in die Zustandsfunktion
    t1.reset();
    stLED = 1; // mit der stLED den State1 anzeigen
  
    // Zyklische Aktionen in der Zustandsfunktion
    while(1)
    {
        // Blinken
        State1Action();
        // Btn's abfragen ( auf Flanken )
        if( Btn1.CheckFlag() )
            { state=2; return; } // vorwärts
        if( Btn2.CheckFlag() ) 
            { state=3; return; } // rückwärts
    }
}

void FahrradLeuchte::State2Func()
{
    // Einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED = 2; // mit der stLED den State1 anzeigen
    t1.reset();
    // Zyklische Aktionen in der Zustandsfunktion
    while(1)
    {
        // Blinken
        State2Action();
        // Btn's abfragen ( auf Flanken )
        if( Btn1.CheckFlag() )
            { state=3; return; } // vorwärts
        if( Btn2.CheckFlag() ) 
            { state=1; return; } // rückwärts
    }
}

void FahrradLeuchte::State3Func()
{
    // Einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED = 3; // mit der stLED den State1 anzeigen
    t1.reset();
    // Zyklische Aktionen in der Zustandsfunktion
    while(1)
    {
        // Blinken
        State3Action();
        // Btn's abfragen ( auf Flanken )
        if( Btn1.CheckFlag() )
            { state=1; return; } // vorwärts
        if( Btn2.CheckFlag() ) 
            { state=2; return; } // rückwärts
    }
}

void FahrradLeuchte::State1Action()
{
    // wenn der timer noch unter 500ms ist haben wir noch nichts zu tun
    if( t1.read_ms()<500 )
        return;
    t1.reset();
    // MSB-Led blinken mit 2Hz
    if( lb==0 )
        lb = 512;
    else
        lb = 0;
}


void FahrradLeuchte::State2Action()
{
    // wenn der timer noch unter 500ms ist haben wir noch nichts zu tun
    if( t1.read_ms()<200 )
        return;
    t1.reset();
    // MSB-Led blinken mit 2Hz
    if( lb==0 )
        lb = 256;
    else
        lb = 0;
}

void FahrradLeuchte::State3Action()
{
    // wenn der timer noch unter 500ms ist haben wir noch nichts zu tun
    if( t1.read_ms()<100 )
        return;
    t1.reset();
    // MSB-Led blinken mit 2Hz
    if( lb==0 )
        lb = 128;
    else
        lb = 0;
}



