#include "mbed.h"
#include "bc_ant.h"

DigitalOut myled(LED1);

Serial pc(USBTX, USBRX);          // USBTX - Tranmit on USB  USBRX - receive on USB
bc_ant antPort(p13, p14, p15);    // for BC-ANT-SERIAL

#define MAX_BUFSIZE   64
#define ANT_CH         0
#define DEVICE_NUMBER 65

/**
 *  Recieved a message from ANT port.
 */
void receivedFromAnt()
{
   uint8_t receivedLength = 0;
   uint8_t receivedBuffer[MAX_BUFSIZE];
   receivedLength = antPort.BC_ANT_RecvPacket(receivedBuffer, MAX_BUFSIZE);

   printf("RX(%3d):", receivedLength);
   for (int index = 0; index < receivedLength; index++)
   {
       printf("%02x ", receivedBuffer[index]);
   }
   printf("\r\n");
}

/**
 *  Moving command received from HOST
 */
void sendToAnt(uint8_t *buffer)
{
    antPort.ANT_SendAcknowledgedData(ANT_CH, buffer);
}

/**
 *   initializes ANT port
 */
int initialize_ANTport(bool isReceive)
{
    antPort.ANT_ResetSystem();
    if (isReceive == true)
    {
        // receiver mode
        antPort.ANT_AssignChannel(ANT_CH, ANT_Bidirectional_Slave, 0);
    }
    else
    {
        // sender mode
        antPort.ANT_AssignChannel(ANT_CH, ANT_Bidirectional_Master, 0);    
    }
    antPort.ANT_SetChannelId(ANT_CH,  DEVICE_NUMBER, 1, 1);

    antPort.ANT_SetChannelPeriod_Hz(ANT_CH, 4);
    antPort.ANT_SetChannelRFFreq(ANT_CH, 4);       // 2404 MHz
    antPort.ANT_OpenChannel(ANT_CH);

    if (isReceive == true)
    {
        // receiver mode
        antPort.attach(&receivedFromAnt);
    }
    else
    {
        // sender mode
        uint8_t buffer[MAX_BUFSIZE] =
        {
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
        };
        antPort.ANT_SendBroadcastData(ANT_CH, buffer);
    }
    return (0);
}


/**
 *   Main Routine
 */
int main()
{
    pc.baud(9600);                  // set serial speed between PC and mbed.
    initialize_ANTport(true);      // initialize BC-ANT-SERIAL for 
    printf("--- READY ----\r\n");

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
