#include "mbed.h"
#include "TextLCD.h"

DigitalOut myled(LED1);

#ifdef TARGET_KL25Z
    //  LCD (RS, E, D4, D5, D6, D7)
    TextLCD lcd(PTA13, PTD5, PTA4, PTA5, PTC8, PTC9); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(PTB0);  // board button
    PwmOut backlight(PTD0);
#endif

/***
 * ---------------------------------------------
 *   Arduino LCD KeyPad Shield (SKU: DFR0009)
 * ---------------------------------------------
 *  - Button            : a0  -> PTB0
 *                                 right  : < 0.15
 *                                 up     : < 0.35
 *                                 down   : < 0.65
 *                                 left   : < 0.99
 *                                 select : ???
 * ---------------------------------------------
 *  - DB4               : d4  -> pta4
 *  - DB5               : d5  -> pta5
 *  - DB6               : d6  -> ptc8
 *  - DB7               : d7  -> ptc9
 *  - RS                : d8  -> pta13
 *  - Enable            : d9  -> ptd5
 *  - Backlight Control : d10 -> ptd0
 * ---------------------------------------------
 *  - http://www.dfrobot.com/wiki/index.php/Arduino_LCD_KeyPad_Shield_(SKU:_DFR0009)
 *  - http://www.dfrobot.com/index.php?route=product/product&keyword=DFR0009&category_id=0&description=1&model=1&product_id=51
 *  - http://www.amazon.co.jp/dp/B00ACCN148
 *  - http://akizukidenshi.com/catalog/g/gM-07029/
***/

int main()
{
    int count = 0;
#ifdef TARGET_KL25Z
    backlight = 1;  // ON: 1, OFF: 0
    lcd.cls();
    lcd.printf("HELLO");
    wait(0.5);
#endif
    while (1)
    {
        myled = (myled == 1) ? 0 : 1;
        count = count + 1;

#ifdef TARGET_KL25Z
        // READ BUTTON VALUE
        unsigned long value = button.read_u16();

        // LCD OUTPUT
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("%d", count);    // loop counter

        lcd.locate(0,1);
        lcd.printf("BUTTON : %04x", value);  // button value
#endif
        wait(0.2);
    }
}
