#include "mbed.h"              
 
Serial pc(USBTX, USBRX); // tx, rx
AnalogIn sound(PTB3);     //Input coming from microphone
DigitalOut micpower(PTA13); //Power for the microphone
Serial wire(PTD3,PTD2);

 
int main()
{
    PwmOut bled(LED_BLUE);
  
    signed int a;         //this is to be the input audio.
    signed int maxa;        //this is the maximum recorded input over a period of time.
    signed int diff;            //this is how much the value of maxa has changed since the last sampling.
    signed int holdmax=10000;   //this is the previous value of maxa;
    signed int lastfive[5];     //this array holds the previous five values of maxa
    signed int avrg;                //this is to be an average of the values in the lastfive array.
    unsigned char flag0=0x00;       
    unsigned char flag1=0x00;   
    unsigned char flag2=0x00;       //these flags show whether the user was typing for the last five samples.
    unsigned char flag3=0x00;
    unsigned char flag4=0x00;
    char typingflag=0;      //this flag shows whether the user is typing currently.
    micpower=1;
           
    pc.printf("Listening\n"); 
    
    lastfive[4]=350;            //these values are to ensure that the average is too high for the program to
    lastfive[3]=350;            //think it is typing to begin with.
    lastfive[2]=350;
    lastfive[1]=350;
    lastfive[0]=350;      
    
    
    while(1)
    {  
        maxa=0;
      for(int x=0; x<10000; x++)
        {
            a=((sound)*2000);
            a=a*a*a;
            a=(a/260000)-3500;          //these lines produce a useful value of a indicating how much the microphone is picking up on.
                        
            if(a>maxa)
            {
            maxa=a;                 //this selects the highest output over the course of a sample.
            }
        }
        
              
       diff=maxa-holdmax; 
            
       lastfive[4]=lastfive[3];
       lastfive[3]=lastfive[2];
       lastfive[2]=lastfive[1];
       lastfive[1]=lastfive[0];
       lastfive[0]=holdmax;
  
       holdmax=maxa;                //this updates the lastfive array and the holdmax variable.
  
       pc.printf("%d ",diff );       //print what is recorded to the PC to make it clear what's going on.
       pc.printf("%d ",maxa );
       
   avrg=(lastfive[0]+lastfive[1]+lastfive[2]+lastfive[3]+lastfive[4])/5;        //find the average of the lastfive array.
   
   if((flag0+flag1+flag2+flag3+flag4)<3)            //if the user hasn't been typing recently.
    {
      if(maxa>(avrg+30))
        {
            typingflag=1;            //set typingflag on
        }
      else 
        {
            typingflag=0;        //set typingflag off
        }
    }    
   else                 //if they haven't been typing recently
    {
       if(maxa>(avrg-40))
        {
            typingflag=1;
        }
       else
        {
            typingflag=0;
        }
    }
   
        flag4=flag3;                //update various flags
        flag3=flag2;
        flag2=flag1;
        flag1=flag0;
        flag0=typingflag;
        
        if(typingflag==1jk,u)
            {
            bled=0.5;
            }
        else
            {
            bled=1;                 //have the blue led show whether typing is being picked up.
            }
   
        wire.putc(typingflag);
}           //end of while loop.
}