#include "mbed.h"
#define ON 12
#define OFF 10

Ticker timeUp;
PwmOut PwmServoMotorR(p24);
PwmOut PwmServoMotorL(p21);
DigitalOut led(LED1);
InterruptIn hemanSens(p30);
int servoMotorR = OFF;
int servoMotorL = ON; 
int cnt = 0;

void counter() {
    cnt++;
}
void riseHemanSens() {
    led = 1;
    cnt = 0;
    servoMotorR = ON;
    servoMotorL = OFF;
}
void fallHemanSens() {
    led = 0;
    cnt = 0;
    servoMotorR = OFF;
    servoMotorL = ON;
}

int main() {    
    timeUp.attach(&counter, 1);
    hemanSens.rise(&riseHemanSens);
    hemanSens.fall(&fallHemanSens);
    
    PwmServoMotorR.period_ms(20);        //20ms    
    PwmServoMotorL.period_ms(20);        //20ms   
    
    while(1) {
        PwmServoMotorR.pulsewidth_us(servoMotorR * 100);     
        PwmServoMotorL.pulsewidth_us(servoMotorL * 100);   
        if( cnt >= 20 ){
            servoMotorR = OFF;
            servoMotorR = ON;
        }
    }
}