/**
 * @section LICENSE
 * Released under the MIT License: http://mbed.org/license/mit
 * Copyright (C) 2012 tosihisa
 *
 * @section DESCRIPTION
 * INA226 - Bi-Directional CURRENT/POWER MONITOR with I2C
 * http://strawberry-linux.com/catalog/items?code=12031
 *
 */
#ifndef __INA226_INCLUDE    // {
#define __INA226_INCLUDE
#include "mbed.h"
/**
 * INA226 Class.
 */
class INA226 {
    public:
        /**
         * Constructor.
         *
         * @param i2c_ instance of I2C.
         * @param addr_ I2C slave address.
         * @param freq_ I2C frequency.
         */
        INA226(I2C &i2c_,int addr_ = 0x80,int freq_ = 100000);
        /**
         * Check INA226 exist.
         *
         * @param none
         * @return 0:NOT EXIST / !0:EXIST
         */
        int isExist(void);
        /**
         * INA226 raw level read.
         *
         * @param pointer_addr INA226 pointer address.
         * @param val_ read value.
         * @return 0:Read OK / !0:Read NG
         */
        int rawRead(char pointer_addr,unsigned short *val_);
        /**
         * INA226 raw level write.
         *
         * @param pointer_addr INA226 pointer address.
         * @param val_ write value.
         * @return 0:Read OK / !0:Read NG
         */
        int rawWrite(char pointer_addr,unsigned short val_);
        /**
         * Get voltage.
         *
         * @param V_ read value;
         * @return 0:Read OK / !0:Read NG
         */
        int getVoltage(double *V_);
        /**
         * Get current.
         *
         * @param I_ read value;
         * @return 0:Read OK / !0:Read NG
         */
        int getCurrent(double *I_);
        /**
         * Set current calibration.
         *
         * @param val write value;
         * @return 0:Read OK / !0:Read NG
         */
        int setCurrentCalibration(unsigned short val = 0x1AAA);

    private:
        I2C &i2c;
        int i2c_addr;
        int freq;
};
#endif  // }
