#include "BLDCmotorDriver.h"

BLDCmotorDriver::BLDCmotorDriver(PinName pGH_A, PinName pGH_B, PinName pGH_C, PinName pGL_A, PinName pGL_B, PinName pGL_C,
                    PinName pH1, PinName pH2, PinName pH3, PinName pFault) : 
                    GH_A(pGH_A), GH_B(pGH_B), GH_C(pGH_C), GL_A(pGL_A), GL_B(pGL_B), GL_C(pGL_C),
                    H1(pH1), H2(pH2), H3(pH3), Fault(LED1){
    HS_usec = 1e9;  //速度表示を0にするため、最初にHS_usecを非常に大きい値にする。HS_usecが0だとprintfにinfと表示される。(main関数での計算上そうなる)              
    sampleTime = 1e-4;
    switchingPeriod = 1.0 / 20e3;   //PWMの周波数を20kHzにしている
    dutyCycle = tempDutyCycle = 0;
    GL_A.period(switchingPeriod); // applies to all PwmOut instances
    H1.rise(this, &BLDCmotorDriver::H1rise);    //U相ホールセンサの立上りだけ回転数計測処理してからcommutation処理するようにしている
    H2.rise(this, &BLDCmotorDriver::commutation);
    H3.rise(this, &BLDCmotorDriver::commutation);
    H1.fall(this, &BLDCmotorDriver::commutation);
    H2.fall(this, &BLDCmotorDriver::commutation);
    H3.fall(this, &BLDCmotorDriver::commutation);
    ticker.attach(this, &BLDCmotorDriver::commutation, sampleTime);
} 
int BLDCmotorDriver::getSector(){           //ホールセンサ信号読み取り モータ回転角検出
    h1 = H1.read();  
    h2 = H2.read();
    h3 = H3.read();
    if(h1 == 0 && h2 == 0 && h3 == 1){ _currentSector = 0; }    
    else if(h1 == 0 && h2 == 1 && h3 == 1){ _currentSector = 1; }        
    else if(h1 == 0 && h2 == 1 && h3 == 0){ _currentSector = 2; }  
    else if(h1 == 1 && h2 == 1 && h3 == 0){ _currentSector = 3; } 
    else if(h1 == 1 && h2 == 0 && h3 == 0){ _currentSector = 4; }
    else if(h1 == 1 && h2 == 0 && h3 == 1){ _currentSector = 5; }           
    currentSector = _currentSector;
    Fault = 0;
    return currentSector;                
}  
void BLDCmotorDriver::H1rise()  {   //H1 (U相ホールセンサ)
    //回転数計測
    HS_check = 0;   //ホールセンサ割込みが起きていることを表すため0を代入
    HS_cnt++;
    t.stop();
    if( t.read_ms() >= 50 ){   //Xms間に何回ホールセンサ(H1)が立ち上がったか確認し、立上りから次の立上りまでの1回あたりの時間を調べる。時間が長いと(200msとか)dutyを急激に変化させたとき、duty制限が追いつかずモータがガタつく(速度で制限を決めているため)。
        HS_usec = t.read_us() / HS_cnt;     //反対に時間が短いと速度計測の精度が落ちる //ちょうどいい時間を探すorプログラム改良が必要
        HS_cnt = 0;
        t.reset();
    }
    t.start();
    //駆動信号出力処理
    commutation();
}    
void BLDCmotorDriver::commutation()  {
    //ホールセンサ間の時間計測の一部
    if( t.read_ms() >= 300 && HS_check ){   //ホールセンサ(U相立上り)割り込みが一定時間発生していない(モータが回転していない場合)の処理
        HS_usec = 1e9;                      //速度表示を0にするためHS_usecを非常に大きい値にする
    }
    HS_check = 1;                           //ホールセンサ割込み関数で0に戻される。割込みが起きない場合(1のまま一定時間過ぎると)HS_usecに1e9代入する処理に繋がる。
    
    //モータ回転数と車両時速の計算
    rpm = (float)(3750 / (HS_usec * 0.001));         //マイクロ秒をミリ秒に直して逆数を3750に掛ける  //BLDCmotorDriver.cpp(.h)で使っている変数をmainで使う場合は「M.」を付ける。「M.」なのはmainの上の方でそう設定してるから。usecはmicro second:マイクロ秒
    speed = rpm * 0.10518;                  //3750とか0.010518は、excelで計算している。ファイル名「」
    //加速の制限
    dc_limit1 = (0.0063*speed*speed + 0.8107*speed + 20.24) / 100;       //加速側制限.elsxの式 //制御確認用モータ用の加速調整(電源電圧13Vにする)   //そのまま車載モータにも使えるかも実際に確認する必要あり。70km/hでduty制限なくなる(dc_limit>=100)
    if( tempDutyCycle > dc_limit1 ){ tempDutyCycle = dc_limit1; }        //加速制限の式で求めた制限値を超えている場合、その値を代入する
    //モード駆動信号出力
    dutyCycle = tempDutyCycle;
    currentSector = getSector();
    if (dutyCycle > 0) {
        if( accel ){
            currentSector++;
            if(currentSector > 5){  currentSector = 0; }
            switch(currentSector) {         /*正転*/        
                case 0:               //001     
                    GL_C = 0; GL_B = 0; GL_A = dutyCycle; GH_C = 0; GH_B = 1; GH_A = 0;
                    break;
                case 1:            
                    GL_C = dutyCycle; GL_B = 0; GL_A = 0; GH_C = 0; GH_B = 1; GH_A = 0; 
                    break;
                case 2:             
                    GL_C = dutyCycle; GL_B = 0; GL_A = 0; GH_C = 0; GH_B = 0; GH_A = 1;
                    break;
                case 3:             
                    GL_C = 0; GL_B = dutyCycle; GL_A = 0; GH_C = 0; GH_B = 0; GH_A = 1;
                    break;
                case 4:              
                    GL_C = 0; GL_B = dutyCycle; GL_A = 0; GH_C = 1; GH_B = 0; GH_A = 0;
                    break;    
                case 5:              
                    GL_C = 0; GL_B = 0; GL_A = dutyCycle; GH_C = 1; GH_B = 0; GH_A = 0;
                    break;
            }
        }
        else if ( !accel ) {    //アクセルOFFのとき
            GL_C = 0; GL_B = 0; GL_A = 0; GH_C = 0; GH_B = 0; GH_A = 0;  //何もしない           
        }
    }
    /*
    else if( dutyCycle < 0 ){
        if( direction ){ //逆転
            currentSector--;
            if(currentSector < 0){ 
                currentSector = 5;
            }
            switch(currentSector) {
                case 0:  
                    GL_C = 0; GL_B = 0; GL_A = -dutyCycle; GH_C = 1; GH_B = 0; GH_A = 0;
                    break;
                case 1:                 
                    GL_C = 0; GL_B = 0; GL_A = -dutyCycle; GH_C = 0; GH_B = 1; GH_A = 0;
                    break;
                case 2:
                    GL_C = -dutyCycle; GL_B = 0; GL_A = 0; GH_C = 0; GH_B = 1; GH_A = 0;
                    break;
                case 3:
                    GL_C = -dutyCycle; GL_B = 0; GL_A = 0; GH_C = 0; GH_B = 0; GH_A = 1;
                    break;
                case 4:
                    GL_C = 0; GL_B = -dutyCycle; GL_A = 0; GH_C = 0; GH_B = 0; GH_A = 1;
                    break;
                case 5:
                    GL_C = 0; GL_B = -dutyCycle; GL_A = 0; GH_C = 1; GH_B = 0; GH_A = 0;
                    break;   
             }
        }
        else if ( !direction ) {    //dutyがマイナスかつ進行方向が後退になっている場合
            GL_C = -dutyCycle; GL_B = -dutyCycle; GL_A = -dutyCycle; GH_C = 0; GH_B = 0; GH_A = 0;  //回生動作する            
        }
    } 
    */
    else if( dutyCycle < 0 ){
        GL_C = -dutyCycle; GL_B = -dutyCycle; GL_A = -dutyCycle; GH_C = 0; GH_B = 0; GH_A = 0;  //回生動作する
    }
}
void BLDCmotorDriver::setDutyCycle(float dc) {
    if (dc >= -1 && dc <= 1) {
        ticker.attach(this, &BLDCmotorDriver::commutation, sampleTime);
        tempDutyCycle = dc;
    } else {
        coast();
    }
}
void BLDCmotorDriver::setDirection(float DS) {
    if (!DS) {
        direction = 0;
    } else {
        direction = 1;
    }
}
void BLDCmotorDriver::coast() {
    GH_A = 0; GL_A = 0; GH_B = 0; GL_B = 0; GH_C = 0; GL_C = 0;
    dutyCycle = tempDutyCycle = 0;
    ticker.detach();
}
float BLDCmotorDriver::getDutyCycle() {
    return dutyCycle;
}