#include "mbed.h"

class BLDCmotorDriver {
    public:
        BLDCmotorDriver(PinName GH_A, PinName GL_A, PinName GH_B, PinName GL_B, PinName GH_C, PinName GL_C, PinName h1, PinName h2, PinName h3, PinName Fault);    
        void configure(float sampleTime, float switchingFrequency, float rampUpSlope, float rampDownSlope);
        void setDutyCycle(float dutyCycle);
        void setDirection(float direction); //方向決定スイッチ
        void coast();
        float getDutyCycle();
        int getSector();
        void ispis();
        short HS_cnt;   //short(min:-32768 max: 32767)で充分   //intとかshortのサイズについて：https://os.mbed.com/users/mbed714/notebook/integer-types-int-long-and-long-long/
        bool HS_check;  //0か1にしかならなｋためboolで宣言
        int HS_usec;
        int rpm_a, rpm_b;  //ホールセンサカウンタ(速度計測用)
        
    private:
        PwmOut GL_A, GL_B, GL_C;       //←ハイサイド・ローサイドの変更
        DigitalOut GH_A, GH_B, GH_C; // Low-side gates are never PWM driven
        InterruptIn H1; // InterruptIn can be used on all pins except p19 and p20
        InterruptIn H2; 
        InterruptIn H3;
        Timer t;    //回転数用大麻
        Ticker ticker;
        float switchingPeriod, dutyCycle, tempDutyCycle, sampleTime;
        int direction;
        void commutation();
        void H1rise();  //ホールセンサ1の立ち上がり時に飛ぶ関数(回転数計測用に使っている)
        int currentSector, _currentSector;
        DigitalOut Fault;
        int h1, h2, h3;
        
        int n;
        //void adjustDutyCycle();
            
};