#include "mbed.h"
#include "RateLimiter.h"

class BLDCmotorDriver {
    public:
        BLDCmotorDriver(PinName GH_A, PinName GL_A, PinName GH_B, PinName GL_B, PinName GH_C, PinName GL_C, PinName h1, PinName h2, PinName h3, PinName Fault);    
        void configure(float sampleTime, float switchingFrequency, float rampUpSlope, float rampDownSlope);
        void setDutyCycle(float dutyCycle);
        void setDirection(float direction); //方向決定スイッチ
        void coast();
        float getDutyCycle();
        int getSector();
        void ispis();
        
    private:
        PwmOut GL_A, GL_B, GL_C;
        DigitalOut GH_A, GH_B, GH_C; // Low-side gates are never PWM driven
        InterruptIn H1; // InterruptIn can be used on all pins except p19 and p20
        InterruptIn H2; 
        InterruptIn H3;
        RateLimiter rl;
        Ticker ticker;
        float switchingPeriod, dutyCycle, tempDutyCycle, sampleTime;
        int direction;
        void commutation();
        int currentSector, _currentSector, previousSector, difference;
        DigitalOut Fault;
        int h1, h2, h3;
        //void adjustDutyCycle();
            
};